/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.util;

import io.camunda.zeebe.logstreams.log.LogStream;
import io.camunda.zeebe.logstreams.log.LogStreamBuilder;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.util.ListLogStorage;
import io.camunda.zeebe.logstreams.util.SyncLogStream;
import io.camunda.zeebe.logstreams.util.SynchronousLogStream;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import java.util.function.Consumer;
import org.agrona.CloseHelper;
import org.junit.rules.ExternalResource;

public final class LogStreamRule
extends ExternalResource {
    private final ControlledActorClock clock = new ControlledActorClock();
    private final boolean shouldStartByDefault;
    private final Consumer<LogStreamBuilder> streamBuilder;
    private SynchronousLogStream logStream;
    private LogStreamReader logStreamReader;
    private LogStreamWriter logStreamWriter;
    private LogStreamBuilder builder;
    private ActorSchedulerRule actorSchedulerRule;
    private ListLogStorage listLogStorage;

    private LogStreamRule(boolean shouldStart, Consumer<LogStreamBuilder> streamBuilder) {
        this.shouldStartByDefault = shouldStart;
        this.streamBuilder = streamBuilder;
    }

    public static LogStreamRule startByDefault(Consumer<LogStreamBuilder> streamBuilder) {
        return new LogStreamRule(true, streamBuilder);
    }

    public static LogStreamRule startByDefault() {
        return new LogStreamRule(true, b -> {});
    }

    protected void before() {
        this.actorSchedulerRule = new ActorSchedulerRule((ActorClock)this.clock);
        this.actorSchedulerRule.before();
        if (this.shouldStartByDefault) {
            this.createLogStream();
        }
    }

    protected void after() {
        this.stopLogStream();
        this.actorSchedulerRule.after();
    }

    public void createLogStream() {
        ActorScheduler actorScheduler = this.actorSchedulerRule.get();
        if (this.listLogStorage == null) {
            this.listLogStorage = new ListLogStorage();
        }
        this.builder = LogStream.builder().withActorSchedulingService((ActorSchedulingService)actorScheduler).withPartitionId(0).withLogName("0").withLogStorage((LogStorage)this.listLogStorage);
        this.streamBuilder.accept(this.builder);
        this.openLogStream();
    }

    private void stopLogStream() {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.logStreamReader, this.logStream});
        this.logStream = null;
        this.logStreamReader = null;
        this.logStreamWriter = null;
        this.listLogStorage = null;
    }

    private void openLogStream() {
        this.logStream = SyncLogStream.builder(this.builder).withActorSchedulingService((ActorSchedulingService)this.actorSchedulerRule.get()).build();
        this.listLogStorage.setPositionListener(this.logStream::setLastWrittenPosition);
    }

    public LogStreamReader newLogStreamReader() {
        return this.logStream.newLogStreamReader();
    }

    public LogStreamReader getLogStreamReader() {
        if (this.logStream == null) {
            throw new IllegalStateException("Log stream is not open!");
        }
        if (this.logStreamReader == null) {
            this.logStreamReader = this.logStream.newLogStreamReader();
        }
        return this.logStreamReader;
    }

    public LogStreamWriter getLogStreamWriter() {
        if (this.logStream == null) {
            throw new IllegalStateException("Log stream is not open!");
        }
        if (this.logStreamWriter == null) {
            this.logStreamWriter = this.logStream.newLogStreamWriter();
        }
        return this.logStreamWriter;
    }

    public SynchronousLogStream getLogStream() {
        return this.logStream;
    }

    public ControlledActorClock getClock() {
        return this.clock;
    }
}

