/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.log;

import io.camunda.zeebe.logstreams.impl.log.LoggedEventImpl;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.util.LogStreamReaderRule;
import io.camunda.zeebe.logstreams.util.LogStreamRule;
import io.camunda.zeebe.logstreams.util.SynchronousLogStream;
import io.camunda.zeebe.logstreams.util.TestEntry;
import io.camunda.zeebe.test.util.asserts.EitherAssert;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public final class LogStreamWriterTest {
    private final LogStreamRule logStreamRule = LogStreamRule.startByDefault();
    private final LogStreamReaderRule readerRule = new LogStreamReaderRule(this.logStreamRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.logStreamRule).around((TestRule)this.readerRule);
    private LogStreamWriter writer;

    @Before
    public void setUp() {
        SynchronousLogStream logStream = this.logStreamRule.getLogStream();
        this.writer = logStream.newLogStreamWriter();
    }

    @After
    public void tearDown() {
        this.writer = null;
    }

    @Test
    public void shouldFailToWriteBatchWithoutEvents() {
        Either result = this.writer.tryWrite(List.of());
        EitherAssert.assertThat((Either)result).isLeft().left().isEqualTo((Object)LogStreamWriter.WriteFailure.INVALID_ARGUMENT);
    }

    @Test
    public void shouldReturnPositionOfWrittenEvent() {
        long position = this.tryWrite(TestEntry.ofDefaults());
        Assertions.assertThat((long)position).isGreaterThan(0L);
        LoggedEvent event = this.getWrittenEvent(position);
        Assertions.assertThat((long)event.getPosition()).isEqualTo(position);
    }

    @Test
    public void shouldReturnPositionOfLastEvent() {
        long position = (Long)this.writer.tryWrite(List.of(TestEntry.ofKey(1L), TestEntry.ofKey(2L))).get();
        Assertions.assertThat((long)position).isGreaterThan(0L);
        List<LoggedEvent> events = this.getWrittenEvents(position);
        Assertions.assertThat(events).hasSize(2);
        Assertions.assertThat((long)events.get(1).getPosition()).isEqualTo(position);
    }

    @Test
    public void shouldWriteEventWithValueBuffer() {
        LogAppendEntry entry = TestEntry.ofDefaults();
        long position = this.tryWrite(entry);
        LoggedEvent event = this.getWrittenEvent(position);
        TestEntry.TestEntryAssert.assertThatEntry(entry).matchesLoggedEvent(event);
    }

    @Test
    public void shouldWriteEventWithMetadataBuffer() {
        LogAppendEntry entry = TestEntry.ofDefaults();
        long position = this.tryWrite(entry);
        LoggedEvent event = this.getWrittenEvent(position);
        TestEntry.TestEntryAssert.assertThatEntry(entry).matchesLoggedEvent(event);
    }

    @Test
    public void shouldWriteEventWithMetadataWriter() {
        LogAppendEntry entry = TestEntry.ofDefaults();
        long position = this.tryWrite(entry);
        LoggedEvent event = this.getWrittenEvent(position);
        TestEntry.TestEntryAssert.assertThatEntry(entry).matchesLoggedEvent(event);
    }

    @Test
    public void shouldWriteEventWithKey() {
        long position = this.tryWrite(TestEntry.ofKey(123L));
        Assertions.assertThat((long)this.getWrittenEvent(position).getKey()).isEqualTo(123L);
    }

    @Test
    public void shouldWriteEventsWithDifferentWriters() {
        long firstPosition = this.tryWrite(TestEntry.ofKey(123L));
        SynchronousLogStream logStream = this.logStreamRule.getLogStream();
        this.writer = logStream.newLogStreamWriter();
        long secondPosition = this.tryWrite(TestEntry.ofKey(124L));
        Assertions.assertThat((long)secondPosition).isGreaterThan(firstPosition);
        Assertions.assertThat((long)this.getWrittenEvent(firstPosition).getKey()).isEqualTo(123L);
        Assertions.assertThat((long)this.getWrittenEvent(secondPosition).getKey()).isEqualTo(124L);
    }

    @Test
    public void shouldCloseAllWritersAndWriteAgain() {
        long firstPosition = this.tryWrite(TestEntry.ofKey(123L));
        this.logStreamRule.getLogStream().awaitPositionWritten(firstPosition);
        this.writer = null;
        SynchronousLogStream logStream = this.logStreamRule.getLogStream();
        this.writer = logStream.newLogStreamWriter();
        long secondPosition = this.tryWrite(TestEntry.ofKey(124L));
        Assertions.assertThat((long)secondPosition).isGreaterThan(firstPosition);
        Assertions.assertThat((long)this.getWrittenEvent(firstPosition).getKey()).isEqualTo(123L);
        Assertions.assertThat((long)this.getWrittenEvent(secondPosition).getKey()).isEqualTo(124L);
    }

    @Test
    public void shouldWriteEventWithSourceEvent() {
        long position = this.tryWrite(TestEntry.ofDefaults(), 123L);
        LoggedEvent event = this.getWrittenEvent(position);
        Assertions.assertThat((long)event.getSourceEventPosition()).isEqualTo(123L);
    }

    @Test
    public void shouldWriteEventWithoutSourceEvent() {
        long position = this.tryWrite(TestEntry.ofDefaults());
        LoggedEvent event = this.getWrittenEvent(position);
        Assertions.assertThat((long)event.getSourceEventPosition()).isEqualTo(-1L);
    }

    @Test
    public void shouldWriteEventWithNullKey() {
        long position = this.tryWrite(TestEntry.ofKey(-1L));
        Assertions.assertThat((long)this.getWrittenEvent(position).getKey()).isEqualTo(-1L);
    }

    @Test
    public void shouldWriteNullKeyByDefault() {
        long position = this.tryWrite(TestEntry.ofDefaults());
        Assertions.assertThat((long)this.getWrittenEvent(position).getKey()).isEqualTo(-1L);
    }

    @Test
    public void shouldFailToWriteEventWithoutValue() {
        Either res = this.writer.tryWrite(TestEntry.builder().withRecordValue(null).build());
        EitherAssert.assertThat((Either)res).isLeft();
    }

    private LoggedEvent getWrittenEvent(long position) {
        Assertions.assertThat((long)position).isGreaterThan(0L);
        this.logStreamRule.getLogStream().awaitPositionWritten(position);
        LoggedEvent event = this.readerRule.readEventAtPosition(position);
        ((ObjectAssert)Assertions.assertThat((Object)event).withFailMessage("No written event found at position: <%s>", new Object[]{position})).isNotNull();
        return event;
    }

    private List<LoggedEvent> getWrittenEvents(long position) {
        ArrayList<LoggedEvent> events = new ArrayList<LoggedEvent>();
        Assertions.assertThat((long)position).isGreaterThan(0L);
        this.logStreamRule.getLogStream().awaitPositionWritten(position);
        long eventPosition = -1L;
        while (eventPosition < position) {
            LoggedEventImpl event = (LoggedEventImpl)this.readerRule.nextEvent();
            LoggedEventImpl eventCopy = new LoggedEventImpl();
            DirectBuffer bufferCopy = BufferUtil.cloneBuffer((DirectBuffer)event.getBuffer());
            eventCopy.wrap(bufferCopy, event.getFragmentOffset());
            events.add((LoggedEvent)eventCopy);
            eventPosition = event.getPosition();
        }
        ((AbstractLongAssert)Assertions.assertThat((long)eventPosition).withFailMessage("No written event found at position: {}", new Object[]{position})).isEqualTo(position);
        return events;
    }

    private long tryWrite(LogAppendEntry entry) {
        return (Long)((Either)Awaitility.await((String)"until dispatcher accepts entry").pollInSameThread().until(() -> this.writer.tryWrite(entry), Either::isRight)).get();
    }

    private long tryWrite(LogAppendEntry entry, long sourcePosition) {
        return (Long)((Either)Awaitility.await((String)"until dispatcher accepts entry").pollInSameThread().until(() -> this.writer.tryWrite(entry, sourcePosition), Either::isRight)).get();
    }
}

