/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.log;

import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.logstreams.util.SyncLogStream;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class LogStreamErrorTest {
    @Parameterized.Parameter(value=0)
    public Throwable logStorageException;
    @Rule
    public ActorSchedulerRule actorSchedulerRule = new ActorSchedulerRule();
    final LogStorage mockLogStorage = (LogStorage)Mockito.mock(LogStorage.class);
    private SyncLogStream logStream;

    @Parameterized.Parameters
    public static Object[][] parameters() {
        return new Object[][]{{new RuntimeException("reader cannot be created")}, {new Error("reader cannot be created")}};
    }

    @Before
    public void setup() {
        ((LogStorage)Mockito.doThrow((Throwable[])new Throwable[]{this.logStorageException}).when((Object)this.mockLogStorage)).newReader();
        this.logStream = SyncLogStream.builder().withLogName("test-log").withLogStorage(this.mockLogStorage).withActorSchedulingService((ActorSchedulingService)this.actorSchedulerRule.get()).build();
    }

    @After
    public void after() {
        this.logStream.close();
    }

    @Test
    public void shouldCompleteFutureWhenCreateWriterFailed() {
        ActorFuture writerFuture = this.logStream.getAsyncLogStream().newLogStreamWriter();
        Awaitility.await().until(() -> writerFuture.isDone());
        Assertions.assertThat((boolean)writerFuture.isCompletedExceptionally()).isTrue();
    }
}

