/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.log.LogStreamBatchReaderImpl;
import io.camunda.zeebe.logstreams.log.LogStreamBatchReader;
import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.logstreams.util.LogStreamReaderRule;
import io.camunda.zeebe.logstreams.util.LogStreamRule;
import io.camunda.zeebe.logstreams.util.TestEntry;
import io.camunda.zeebe.util.ByteValue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class LogStreamBatchReaderTest {
    private static final int LOG_SEGMENT_SIZE = (int)ByteValue.ofMegabytes((long)4L);
    private final LogStreamRule logStreamRule = LogStreamRule.startByDefault(builder -> builder.withMaxFragmentSize(LOG_SEGMENT_SIZE));
    private final LogStreamReaderRule readerRule = new LogStreamReaderRule(this.logStreamRule);
    @Rule
    public final RuleChain ruleChain = RuleChain.outerRule((TestRule)this.logStreamRule).around((TestRule)this.readerRule);
    private LogStreamBatchReader batchReader;
    private LogStreamWriter writer;

    @Before
    public void setUp() {
        LogStreamReader logStreamReader = this.readerRule.getLogStreamReader();
        this.batchReader = new LogStreamBatchReaderImpl(logStreamReader);
        this.writer = this.logStreamRule.getLogStream().newSyncLogStreamWriter();
    }

    @Test
    public void shouldNotHaveNextIfEmpty() {
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isFalse();
    }

    @Test
    public void shouldReadEventsInBatch() {
        long eventPosition1 = (Long)this.writer.tryWrite(TestEntry.ofKey(1L), 1L).get();
        long eventPosition2 = (Long)this.writer.tryWrite(TestEntry.ofKey(2L), 1L).get();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((Iterator)batch).isNotNull();
        Assertions.assertThat((boolean)batch.hasNext()).isTrue();
        LoggedEvent event1 = (LoggedEvent)batch.next();
        Assertions.assertThat((long)event1.getKey()).isEqualTo(1L);
        Assertions.assertThat((long)event1.getPosition()).isEqualTo(eventPosition1);
        Assertions.assertThat((boolean)batch.hasNext()).isTrue();
        LoggedEvent event2 = (LoggedEvent)batch.next();
        Assertions.assertThat((long)event2.getKey()).isEqualTo(2L);
        Assertions.assertThat((long)event2.getPosition()).isEqualTo(eventPosition2);
        Assertions.assertThat((boolean)batch.hasNext()).isFalse();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isFalse();
    }

    @Test
    public void shouldReadNextBatch() {
        long eventPosition1 = (Long)this.writer.tryWrite(TestEntry.ofKey(1L)).get();
        long eventPosition2 = (Long)this.writer.tryWrite(TestEntry.ofKey(2L)).get();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch1 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch1.hasNext()).isTrue();
        LoggedEvent event1 = (LoggedEvent)batch1.next();
        Assertions.assertThat((long)event1.getKey()).isEqualTo(1L);
        Assertions.assertThat((long)event1.getPosition()).isEqualTo(eventPosition1);
        Assertions.assertThat((boolean)batch1.hasNext()).isFalse();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch2 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch2.hasNext()).isTrue();
        LoggedEvent event2 = (LoggedEvent)batch2.next();
        Assertions.assertThat((long)event2.getKey()).isEqualTo(2L);
        Assertions.assertThat((long)event2.getPosition()).isEqualTo(eventPosition2);
        Assertions.assertThat((boolean)batch2.hasNext()).isFalse();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isFalse();
    }

    @Test
    public void shouldReadEventsWithoutSourceEventPosition() {
        long eventPosition1 = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        long eventPosition2 = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch1 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch1.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch1.next()).getPosition()).isEqualTo(eventPosition1);
        Assertions.assertThat((boolean)batch1.hasNext()).isFalse();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch2 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch2.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch2.next()).getPosition()).isEqualTo(eventPosition2);
    }

    @Test
    public void shouldNotIncludeEventsWithoutSourceEventPosition() {
        long eventPosition1 = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        long eventPosition2 = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        long eventPosition3 = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch1 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch1.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch1.next()).getPosition()).isEqualTo(eventPosition1);
        Assertions.assertThat((boolean)batch1.hasNext()).isFalse();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch2 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch2.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch2.next()).getPosition()).isEqualTo(eventPosition2);
        Assertions.assertThat((boolean)batch2.hasNext()).isFalse();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch3 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch3.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch3.next()).getPosition()).isEqualTo(eventPosition3);
    }

    @Test
    public void shouldMoveBatchToHead() {
        long eventPosition1 = (Long)this.writer.tryWrite(TestEntry.ofDefaults(), 1L).get();
        long eventPosition2 = (Long)this.writer.tryWrite(TestEntry.ofDefaults(), 1L).get();
        long eventPosition3 = (Long)this.writer.tryWrite(TestEntry.ofDefaults(), 2L).get();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch1 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch1.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch1.next()).getPosition()).isEqualTo(eventPosition1);
        batch1.head();
        Assertions.assertThat((boolean)batch1.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch1.next()).getPosition()).isEqualTo(eventPosition1);
        Assertions.assertThat((boolean)batch1.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch1.next()).getPosition()).isEqualTo(eventPosition2);
        Assertions.assertThat((boolean)batch1.hasNext()).isFalse();
        LogStreamBatchReader.Batch batch2 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch2.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch2.next()).getPosition()).isEqualTo(eventPosition3);
    }

    @Test
    public void shouldSkipEventsInBatch() {
        long eventPosition1 = (Long)this.writer.tryWrite(TestEntry.ofDefaults(), 1L).get();
        this.writer.tryWrite(TestEntry.ofDefaults(), 1L);
        long eventPosition3 = (Long)this.writer.tryWrite(TestEntry.ofDefaults(), 2L).get();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch1 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch1.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch1.next()).getPosition()).isEqualTo(eventPosition1);
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch2 = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch2.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch2.next()).getPosition()).isEqualTo(eventPosition3);
    }

    @Test
    public void shouldSeekToHeadIfNegative() {
        long eventPosition1 = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        this.writer.tryWrite(TestEntry.ofDefaults());
        boolean found = this.batchReader.seekToNextBatch(-1L);
        Assertions.assertThat((boolean)found).isTrue();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch.next()).getPosition()).isEqualTo(eventPosition1);
    }

    @Test
    public void shouldSeekToNextBatch() {
        this.writer.tryWrite(TestEntry.ofDefaults());
        long eventPosition2 = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        long eventPosition3 = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        boolean found = this.batchReader.seekToNextBatch(eventPosition2);
        Assertions.assertThat((boolean)found).isTrue();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch.next()).getPosition()).isEqualTo(eventPosition3);
    }

    @Test
    public void shouldSeekToNextEventWithinBatch() {
        long eventPosition1 = (Long)this.writer.tryWrite(TestEntry.ofDefaults(), 1L).get();
        this.writer.tryWrite(TestEntry.ofDefaults(), 1L);
        long eventPosition3 = (Long)this.writer.tryWrite(TestEntry.ofDefaults(), 2L).get();
        boolean found = this.batchReader.seekToNextBatch(eventPosition1);
        Assertions.assertThat((boolean)found).isTrue();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch = (LogStreamBatchReader.Batch)this.batchReader.next();
        Assertions.assertThat((boolean)batch.hasNext()).isTrue();
        Assertions.assertThat((long)((LoggedEvent)batch.next()).getPosition()).isEqualTo(eventPosition3);
    }

    @Test
    public void shouldSeekToTailIfLastEvent() {
        this.writer.tryWrite(TestEntry.ofDefaults());
        long eventPosition2 = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        boolean found = this.batchReader.seekToNextBatch(eventPosition2);
        Assertions.assertThat((boolean)found).isTrue();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isFalse();
    }

    @Test
    public void shouldSeekToNotExistingPosition() {
        Long eventPosition = (Long)this.writer.tryWrite(TestEntry.ofDefaults()).get();
        boolean found = this.batchReader.seekToNextBatch(eventPosition + 1L);
        Assertions.assertThat((boolean)found).isFalse();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isFalse();
    }

    @Test
    public void shouldNotHaveNextIfClosed() {
        this.batchReader.close();
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isFalse();
    }

    @Test
    public void shouldThrowNoSuchElementExceptionOnNextBatch() {
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isFalse();
        Assertions.assertThatThrownBy(() -> this.batchReader.next()).isInstanceOf(NoSuchElementException.class);
    }

    @Test
    public void shouldThrowNoSuchElementExceptionOnNextEvent() {
        this.writer.tryWrite(TestEntry.ofKey(1L));
        Assertions.assertThat((boolean)this.batchReader.hasNext()).isTrue();
        LogStreamBatchReader.Batch batch = (LogStreamBatchReader.Batch)this.batchReader.next();
        batch.next();
        Assertions.assertThat((boolean)batch.hasNext()).isFalse();
        Assertions.assertThatThrownBy(() -> batch.next()).isInstanceOf(NoSuchElementException.class);
    }
}

