/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.limit.AbstractLimit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.BackpressureCfgVegas;
import io.camunda.zeebe.util.Environment;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public final class AppendVegasLimiterTest {
    @Test
    public void shouldUseDefaultValues() {
        BackpressureCfgVegas vegasCfg = new BackpressureCfgVegas();
        Assertions.assertThat((double)vegasCfg.getAlphaLimit()).isEqualTo(0.7);
        Assertions.assertThat((double)vegasCfg.getBetaLimit()).isEqualTo(0.95);
        Assertions.assertThat((int)vegasCfg.getInitialLimit()).isEqualTo(1024);
        Assertions.assertThat((int)vegasCfg.getMaxConcurrency()).isEqualTo(32768);
    }

    @Test
    public void shouldUseDefaultValuesForNoExistingValues() {
        Environment environment = new Environment();
        BackpressureCfgVegas vegasCfg = new BackpressureCfgVegas();
        vegasCfg.applyEnvironment(environment);
        Assertions.assertThat((double)vegasCfg.getAlphaLimit()).isEqualTo(0.7);
        Assertions.assertThat((double)vegasCfg.getBetaLimit()).isEqualTo(0.95);
        Assertions.assertThat((int)vegasCfg.getInitialLimit()).isEqualTo(1024);
        Assertions.assertThat((int)vegasCfg.getMaxConcurrency()).isEqualTo(32768);
    }

    @Test
    public void shouldConfigure() {
        Map<String, String> cfgMap = Map.of("ZEEBE_BP_APPENDER_VEGAS_INIT_LIMIT", "12", "ZEEBE_BP_APPENDER_VEGAS_MAX_CONCURRENCY", "24", "ZEEBE_BP_APPENDER_VEGAS_ALPHA_LIMIT", "0.1", "ZEEBE_BP_APPENDER_VEGAS_BETA_LIMIT", "0.5");
        Environment environment = new Environment(cfgMap);
        BackpressureCfgVegas vegasCfg = new BackpressureCfgVegas();
        vegasCfg.applyEnvironment(environment);
        Assertions.assertThat((double)vegasCfg.getAlphaLimit()).isEqualTo(0.1);
        Assertions.assertThat((double)vegasCfg.getBetaLimit()).isEqualTo(0.5);
        Assertions.assertThat((int)vegasCfg.getInitialLimit()).isEqualTo(12);
        Assertions.assertThat((int)vegasCfg.getMaxConcurrency()).isEqualTo(24);
    }

    @Test
    public void shouldBuild() {
        BackpressureCfgVegas vegasCfg = new BackpressureCfgVegas();
        AbstractLimit abstractLimit = vegasCfg.get();
        Assertions.assertThat((int)abstractLimit.getLimit()).isEqualTo(1024);
    }
}

