/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.limit.AbstractLimit;
import io.camunda.zeebe.logstreams.impl.flowcontrol.BackpressureCfgGradient2;
import io.camunda.zeebe.util.Environment;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public final class AppendGradient2LimiterTest {
    @Test
    public void shouldUseDefaultValues() {
        BackpressureCfgGradient2 gradient2Cfg = new BackpressureCfgGradient2();
        Assertions.assertThat((int)gradient2Cfg.getInitialLimit()).isEqualTo(1024);
        Assertions.assertThat((int)gradient2Cfg.getMaxConcurrency()).isEqualTo(32768);
        Assertions.assertThat((int)gradient2Cfg.getLongWindow()).isEqualTo(1200);
        Assertions.assertThat((int)gradient2Cfg.getMinLimit()).isEqualTo(256);
        Assertions.assertThat((int)gradient2Cfg.getQueueSize()).isEqualTo(32);
        Assertions.assertThat((double)gradient2Cfg.getRttTolerance()).isEqualTo(1.5);
    }

    @Test
    public void shouldUseDefaultValuesForNoExistingValues() {
        Environment environment = new Environment();
        BackpressureCfgGradient2 gradient2Cfg = new BackpressureCfgGradient2();
        gradient2Cfg.applyEnvironment(environment);
        Assertions.assertThat((int)gradient2Cfg.getInitialLimit()).isEqualTo(1024);
        Assertions.assertThat((int)gradient2Cfg.getMaxConcurrency()).isEqualTo(32768);
        Assertions.assertThat((int)gradient2Cfg.getLongWindow()).isEqualTo(1200);
        Assertions.assertThat((int)gradient2Cfg.getMinLimit()).isEqualTo(256);
        Assertions.assertThat((int)gradient2Cfg.getQueueSize()).isEqualTo(32);
        Assertions.assertThat((double)gradient2Cfg.getRttTolerance()).isEqualTo(1.5);
    }

    @Test
    public void shouldConfigure() {
        Map<String, String> cfgMap = Map.of("ZEEBE_BP_APPENDER_GRADIENT2_INIT_LIMIT", "12", "ZEEBE_BP_APPENDER_GRADIENT2_MAX_CONCURRENCY", "24", "ZEEBE_BP_APPENDER_GRADIENT2_LONG_WINDOW", "300", "ZEEBE_BP_APPENDER_GRADIENT2_QUEUE_SIZE", "3", "ZEEBE_BP_APPENDER_GRADIENT2_RTT_TOLERANCE", "0.3", "ZEEBE_BP_APPENDER_VEGAS_BETA_LIMIT", "1");
        Environment environment = new Environment(cfgMap);
        BackpressureCfgGradient2 gradient2Cfg = new BackpressureCfgGradient2();
        gradient2Cfg.applyEnvironment(environment);
        Assertions.assertThat((int)gradient2Cfg.getInitialLimit()).isEqualTo(12);
        Assertions.assertThat((int)gradient2Cfg.getMaxConcurrency()).isEqualTo(24);
        Assertions.assertThat((int)gradient2Cfg.getLongWindow()).isEqualTo(300);
        Assertions.assertThat((int)gradient2Cfg.getMinLimit()).isEqualTo(1);
        Assertions.assertThat((int)gradient2Cfg.getQueueSize()).isEqualTo(3);
        Assertions.assertThat((double)gradient2Cfg.getRttTolerance()).isEqualTo(0.3);
    }

    @Test
    public void shouldBuild() {
        BackpressureCfgGradient2 gradient2Cfg = new BackpressureCfgGradient2();
        AbstractLimit abstractLimit = gradient2Cfg.get();
        Assertions.assertThat((int)abstractLimit.getLimit()).isEqualTo(1024);
    }
}

