/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRuntimeInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationStartInstruction;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.value.RuntimeInstructionType;
import java.util.List;
import java.util.Set;
import org.agrona.DirectBuffer;

public class BrokerCreateProcessInstanceRequest
extends BrokerExecuteCommand<ProcessInstanceCreationRecord> {
    private final ProcessInstanceCreationRecord requestDto = new ProcessInstanceCreationRecord();

    public BrokerCreateProcessInstanceRequest() {
        super(ValueType.PROCESS_INSTANCE_CREATION, (Intent)ProcessInstanceCreationIntent.CREATE);
    }

    public BrokerCreateProcessInstanceRequest setBpmnProcessId(String bpmnProcessId) {
        this.requestDto.setBpmnProcessId(bpmnProcessId);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setKey(long key) {
        this.requestDto.setProcessDefinitionKey(key);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setVersion(int version) {
        this.requestDto.setVersion(version);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setVariables(DirectBuffer variables) {
        this.requestDto.setVariables(variables);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setTenantId(String tenantId) {
        this.requestDto.setTenantId(tenantId);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setTags(Set<String> tags) {
        this.requestDto.setTags(tags);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setStartInstructions(List<GatewayOuterClass.ProcessInstanceCreationStartInstruction> startInstructionsList) {
        startInstructionsList.stream().map(startInstructionReq -> new ProcessInstanceCreationStartInstruction().setElementId(startInstructionReq.getElementId())).forEach(arg_0 -> ((ProcessInstanceCreationRecord)this.requestDto).addStartInstruction(arg_0));
        return this;
    }

    public BrokerCreateProcessInstanceRequest setStartInstructionsFromRecord(List<ProcessInstanceCreationStartInstruction> instructions) {
        this.requestDto.addStartInstructions(instructions);
        return this;
    }

    public BrokerCreateProcessInstanceRequest setRuntimeInstructions(List<GatewayOuterClass.ProcessInstanceCreationRuntimeInstruction> runtimeInstructions) {
        runtimeInstructions.stream().map(instruction -> {
            switch (instruction.getInstructionCase()) {
                default: {
                    throw new MatchException(null, null);
                }
                case TERMINATE: {
                    return new ProcessInstanceCreationRuntimeInstruction().setType(RuntimeInstructionType.TERMINATE_PROCESS_INSTANCE).setAfterElementId(instruction.getTerminate().getAfterElementId());
                }
                case INSTRUCTION_NOT_SET: {
                    throw new IllegalArgumentException("Unsupported runtime instruction type: " + instruction.getInstructionCase().name());
                }
            }
        }).forEach(arg_0 -> ((ProcessInstanceCreationRecord)this.requestDto).addRuntimeInstruction(arg_0));
        return this;
    }

    public BrokerCreateProcessInstanceRequest setRuntimeInstructionsFromRecord(List<ProcessInstanceCreationRuntimeInstruction> runtimeInstructions) {
        this.requestDto.addRuntimeInstructions(runtimeInstructions);
        return this;
    }

    public ProcessInstanceCreationRecord getRequestWriter() {
        return this.requestDto;
    }

    protected ProcessInstanceCreationRecord toResponseDto(DirectBuffer buffer) {
        ProcessInstanceCreationRecord responseDto = new ProcessInstanceCreationRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }
}

