/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.protocol.impl.record.value.authorization.AuthorizationRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.AuthorizationIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.AuthorizationOwnerType;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceMatcher;
import io.camunda.zeebe.protocol.record.value.AuthorizationResourceType;
import io.camunda.zeebe.protocol.record.value.PermissionType;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Set;
import org.agrona.DirectBuffer;

public class BrokerAuthorizationRequest
extends BrokerExecuteCommand<AuthorizationRecord> {
    private final AuthorizationRecord requestDto = new AuthorizationRecord();

    public BrokerAuthorizationRequest(AuthorizationIntent intent) {
        super(ValueType.AUTHORIZATION, (Intent)intent);
        this.setPartitionId(1);
    }

    public BrokerAuthorizationRequest setAuthorizationKey(long authorizationKey) {
        this.requestDto.setAuthorizationKey(Long.valueOf(authorizationKey));
        return this;
    }

    public BrokerAuthorizationRequest setOwnerId(String ownerId) {
        this.requestDto.setOwnerId(ownerId);
        return this;
    }

    public BrokerAuthorizationRequest setOwnerType(AuthorizationOwnerType ownerType) {
        this.requestDto.setOwnerType(ownerType);
        return this;
    }

    public BrokerAuthorizationRequest setResourceMatcher(AuthorizationResourceMatcher resourceMatcher) {
        this.requestDto.setResourceMatcher(resourceMatcher);
        return this;
    }

    public BrokerAuthorizationRequest setResourceId(String resourceId) {
        this.requestDto.setResourceId(resourceId);
        return this;
    }

    public BrokerAuthorizationRequest setResourceType(AuthorizationResourceType resourceType) {
        this.requestDto.setResourceType(resourceType);
        return this;
    }

    public BrokerAuthorizationRequest setPermissionTypes(Set<PermissionType> permissionTypes) {
        this.requestDto.setPermissionTypes(permissionTypes);
        return this;
    }

    public BufferWriter getRequestWriter() {
        return this.requestDto;
    }

    protected AuthorizationRecord toResponseDto(DirectBuffer buffer) {
        AuthorizationRecord response = new AuthorizationRecord();
        response.wrap(buffer);
        return response;
    }
}

