/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.broker.client.api.BrokerTopologyListener;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.dynamic.config.state.RoutingState;
import io.camunda.zeebe.gateway.api.util.TestBrokerClusterState;
import io.camunda.zeebe.gateway.impl.broker.PublishMessageDispatchStrategy;
import io.camunda.zeebe.protocol.impl.SubscriptionUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class PublishMessageDispatchStrategyTest {
    PublishMessageDispatchStrategyTest() {
    }

    @Test
    void shouldDispatchViaTopology() {
        String correlationKey = "correlationKey";
        PublishMessageDispatchStrategy dispatchStrategy = new PublishMessageDispatchStrategy("correlationKey");
        int partitionCount = 3;
        TestTopologyManager topologyManager = new TestTopologyManager(new TestBrokerClusterState(3), ClusterConfiguration.uninitialized());
        Assertions.assertThat((int)dispatchStrategy.determinePartition((BrokerTopologyManager)topologyManager)).isEqualTo(SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)BufferUtil.wrapString((String)"correlationKey"), (int)3));
    }

    @Test
    void shouldDispatchViaRoutingState() {
        String correlationKey = "correlationKey";
        PublishMessageDispatchStrategy dispatchStrategy = new PublishMessageDispatchStrategy("correlationKey");
        int partitionCount = 3;
        int messagePartitionCount = 2;
        RoutingState routingState = new RoutingState(1L, (RoutingState.RequestHandling)new RoutingState.RequestHandling.AllPartitions(3), (RoutingState.MessageCorrelation)new RoutingState.MessageCorrelation.HashMod(2));
        ClusterConfiguration clusterConfiguration = new ClusterConfiguration(1L, Map.of(), Optional.empty(), Optional.empty(), Optional.of(routingState));
        TestTopologyManager topologyManager = new TestTopologyManager(new TestBrokerClusterState(3), clusterConfiguration);
        Assertions.assertThat((int)dispatchStrategy.determinePartition((BrokerTopologyManager)topologyManager)).isEqualTo(SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)BufferUtil.wrapString((String)"correlationKey"), (int)2));
    }

    private record TestTopologyManager(BrokerClusterState topology, ClusterConfiguration clusterConfiguration) implements BrokerTopologyManager
    {
        public BrokerClusterState getTopology() {
            return this.topology;
        }

        public ClusterConfiguration getClusterConfiguration() {
            return this.clusterConfiguration;
        }

        public void addTopologyListener(BrokerTopologyListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removeTopologyListener(BrokerTopologyListener listener) {
            throw new UnsupportedOperationException();
        }

        public void onClusterConfigurationUpdated(ClusterConfiguration clusterConfiguration) {
            throw new UnsupportedOperationException();
        }
    }
}

