/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.api.util;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public final class TestBrokerClusterState
implements BrokerClusterState {
    private final Map<Integer, String> brokerAddresses = new HashMap<Integer, String>();
    private final Map<Integer, Tuple<Integer, Long>> partitionLeaders = new HashMap<Integer, Tuple<Integer, Long>>();
    private final Set<Integer> partitions = new HashSet<Integer>();
    private final Map<Tuple<Integer, Integer>, PartitionHealthStatus> brokerPartitionHealthStatus = new HashMap<Tuple<Integer, Integer>, PartitionHealthStatus>();
    private final Map<Integer, Set<Integer>> inactivePartitionsToNodeIds = new HashMap<Integer, Set<Integer>>();
    private final Map<Integer, Set<Integer>> followerPartitionToNodeIds = new HashMap<Integer, Set<Integer>>();

    public TestBrokerClusterState() {
        this(0);
    }

    public TestBrokerClusterState(int partitionCount) {
        IntStream.range(1, 1 + partitionCount).forEach(pId -> {
            this.partitions.add(pId);
            this.partitionLeaders.put(pId, (Tuple<Integer, Long>)Tuple.of((Object)-2, (Object)0L));
            this.inactivePartitionsToNodeIds.put(pId, new HashSet());
            this.followerPartitionToNodeIds.put(pId, new HashSet());
        });
    }

    public boolean isInitialized() {
        return true;
    }

    public int getClusterSize() {
        return this.brokerAddresses.size();
    }

    public int getPartitionsCount() {
        return this.partitions.size();
    }

    public int getReplicationFactor() {
        return 1;
    }

    public int getLeaderForPartition(int partition) {
        if (!this.partitionLeaders.containsKey(partition)) {
            return -2;
        }
        return (Integer)this.partitionLeaders.get(partition).getLeft();
    }

    public Set<Integer> getFollowersForPartition(int partition) {
        return this.followerPartitionToNodeIds.getOrDefault(partition, Set.of());
    }

    public Set<Integer> getInactiveNodesForPartition(int partition) {
        return this.inactivePartitionsToNodeIds.getOrDefault(partition, Set.of());
    }

    public int getRandomBroker() {
        throw new UnsupportedOperationException();
    }

    public List<Integer> getPartitions() {
        return this.partitions.stream().toList();
    }

    public List<Integer> getBrokers() {
        return new ArrayList<Integer>(this.brokerAddresses.keySet());
    }

    public String getBrokerAddress(int brokerId) {
        return this.brokerAddresses.get(brokerId);
    }

    public String getBrokerVersion(int brokerId) {
        return "1.0.0";
    }

    public PartitionHealthStatus getPartitionHealth(int brokerId, int partition) {
        return this.brokerPartitionHealthStatus.getOrDefault(Tuple.of((Object)brokerId, (Object)partition), PartitionHealthStatus.UNHEALTHY);
    }

    public long getLastCompletedChangeId() {
        throw new UnsupportedOperationException();
    }

    public void addBroker(int nodeId, String address) {
        this.brokerAddresses.put(nodeId, address);
    }

    public void setPartitionLeader(int partitionId, int leaderId, long term) {
        this.partitionLeaders.put(partitionId, (Tuple<Integer, Long>)Tuple.of((Object)leaderId, (Object)term));
    }

    public void addPartition(int partitionId) {
        this.partitions.add(partitionId);
    }

    public void setPartitionHealthStatus(int nodeId, int partitionId, PartitionHealthStatus partitionHealthStatus) {
        this.brokerPartitionHealthStatus.put((Tuple<Integer, Integer>)Tuple.of((Object)nodeId, (Object)partitionId), partitionHealthStatus);
    }

    public void addPartitionInactive(int partitionId, int nodeId) {
        this.addPartition(partitionId);
        this.inactivePartitionsToNodeIds.compute(partitionId, (key, value) -> {
            if (value == null) {
                value = new HashSet<Integer>();
            }
            value.add(nodeId);
            return value;
        });
        this.followerPartitionToNodeIds.compute(partitionId, (key, value) -> {
            if (value == null) {
                return null;
            }
            value.remove(nodeId);
            return value;
        });
        if (this.partitionLeaders.containsKey(partitionId)) {
            this.partitionLeaders.remove(partitionId);
        }
    }

    public void addFollowerPartition(int partitionId, int nodeId) {
        this.followerPartitionToNodeIds.compute(partitionId, (key, value) -> {
            if (value == null) {
                value = new HashSet<Integer>();
            }
            value.add(nodeId);
            return value;
        });
    }
}

