/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.api.util;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.broker.client.api.BrokerTopologyListener;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;
import io.camunda.zeebe.gateway.api.util.TestBrokerClusterState;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;

public final class StubbedTopologyManager
implements BrokerTopologyManager {
    private final TestBrokerClusterState clusterState;
    private final ClusterConfiguration clusterConfiguration = ClusterConfiguration.uninitialized();

    StubbedTopologyManager() {
        this(8);
    }

    StubbedTopologyManager(int partitionsCount) {
        this.clusterState = new TestBrokerClusterState(partitionsCount);
        this.clusterState.addBroker(0, "localhost:26501");
        for (int partitionOffset = 0; partitionOffset < partitionsCount; ++partitionOffset) {
            this.clusterState.setPartitionLeader(1 + partitionOffset, 0, 1L);
            this.clusterState.addPartition(1 + partitionOffset);
        }
    }

    public BrokerClusterState getTopology() {
        return this.clusterState;
    }

    public ClusterConfiguration getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public void addTopologyListener(BrokerTopologyListener listener) {
        throw new UnsupportedOperationException("Not yet implemented; implement if need be");
    }

    public void removeTopologyListener(BrokerTopologyListener listener) {
        throw new UnsupportedOperationException("Not yet implemented; implement if need be");
    }

    public void onClusterConfigurationUpdated(ClusterConfiguration clusterConfiguration) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setPartitionHealthStatus(int nodeId, int partitionId, PartitionHealthStatus partitionHealthStatus) {
        this.clusterState.setPartitionHealthStatus(nodeId, partitionId, partitionHealthStatus);
    }

    public void addPartitionInactive(int partitionId, int nodeId) {
        this.clusterState.addPartitionInactive(partitionId, nodeId);
    }
}

