/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.configuration;

import io.atomix.cluster.messaging.MessagingConfig;
import io.atomix.utils.net.Address;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.configuration.ConfigManagerCfg;
import io.camunda.zeebe.gateway.impl.configuration.ConfigurationDefaults;
import io.camunda.zeebe.gateway.impl.configuration.MembershipCfg;
import io.camunda.zeebe.gateway.impl.configuration.SecurityCfg;
import io.camunda.zeebe.util.StringUtil;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.util.unit.DataSize;

public final class ClusterCfg {
    private static final String DEFAULT_ADVERTISED_HOST = Address.defaultAdvertisedHost().getHostAddress();
    private List<String> initialContactPoints = Collections.singletonList("127.0.0.1:26502");
    private Duration requestTimeout = ConfigurationDefaults.DEFAULT_REQUEST_TIMEOUT;
    private String clusterName = "zeebe-cluster";
    private String memberId = "gateway";
    private String host = null;
    private String advertisedHost = null;
    private int port = 26502;
    private Integer advertisedPort = null;
    private MembershipCfg membership = new MembershipCfg();
    private SecurityCfg security = new SecurityCfg();
    private MessagingConfig.CompressionAlgorithm messageCompression = MessagingConfig.CompressionAlgorithm.NONE;
    private ConfigManagerCfg configManager = ConfigManagerCfg.defaultConfig();
    private DataSize socketSendBuffer = null;
    private DataSize socketReceiveBuffer = null;

    public String getMemberId() {
        return this.memberId;
    }

    public ClusterCfg setMemberId(String memberId) {
        this.memberId = memberId;
        return this;
    }

    public String getHost() {
        return this.host != null ? this.host : "0.0.0.0";
    }

    public ClusterCfg setHost(String host) {
        this.host = host;
        return this;
    }

    public String getAdvertisedHost() {
        if (this.advertisedHost != null) {
            return this.advertisedHost;
        }
        if (this.host != null) {
            return this.host;
        }
        return DEFAULT_ADVERTISED_HOST;
    }

    public ClusterCfg setAdvertisedHost(String advertisedHost) {
        this.advertisedHost = advertisedHost;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ClusterCfg setPort(int port) {
        this.port = port;
        return this;
    }

    public int getAdvertisedPort() {
        return Optional.ofNullable(this.advertisedPort).orElseGet(this::getPort);
    }

    public ClusterCfg setAdvertisedPort(int advertisedPort) {
        this.advertisedPort = advertisedPort;
        return this;
    }

    @Deprecated(since="8.1.0", forRemoval=true)
    public ClusterCfg setContactPoint(String contactPoint) {
        Loggers.GATEWAY_CFG_LOGGER.warn("Configuring deprecated property 'contactPoint', will use 'initialContactPoints'. Please consider to migrate to 'initialContactPoints' property, which allows to set a list of contact points.");
        this.setInitialContactPoints(Collections.singletonList(contactPoint));
        return this;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public ClusterCfg setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ClusterCfg setClusterName(String name) {
        this.clusterName = name;
        return this;
    }

    public MembershipCfg getMembership() {
        return this.membership;
    }

    public void setMembership(MembershipCfg membership) {
        this.membership = membership;
    }

    public SecurityCfg getSecurity() {
        return this.security;
    }

    public ClusterCfg setSecurity(SecurityCfg security) {
        this.security = security;
        return this;
    }

    public MessagingConfig.CompressionAlgorithm getMessageCompression() {
        return this.messageCompression;
    }

    public void setMessageCompression(MessagingConfig.CompressionAlgorithm compressionAlgorithm) {
        this.messageCompression = compressionAlgorithm;
    }

    public List<String> getInitialContactPoints() {
        return this.initialContactPoints;
    }

    public ClusterCfg setInitialContactPoints(List<String> initialContactPoints) {
        this.initialContactPoints = (List)StringUtil.LIST_SANITIZER.apply(initialContactPoints);
        return this;
    }

    public ConfigManagerCfg getConfigManager() {
        return this.configManager;
    }

    public ClusterCfg setConfigManager(ConfigManagerCfg configManagerCfg) {
        this.configManager = configManagerCfg;
        return this;
    }

    public DataSize getSocketSendBuffer() {
        return this.socketSendBuffer;
    }

    public ClusterCfg setSocketSendBuffer(DataSize socketSendBuffer) {
        this.socketSendBuffer = socketSendBuffer;
        return this;
    }

    public DataSize getSocketReceiveBuffer() {
        return this.socketReceiveBuffer;
    }

    public ClusterCfg setSocketReceiveBuffer(DataSize socketReceiveBuffer) {
        this.socketReceiveBuffer = socketReceiveBuffer;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.initialContactPoints, this.requestTimeout, this.clusterName, this.memberId, this.host, this.port, this.membership, this.security, this.messageCompression, this.configManager, this.socketSendBuffer, this.socketReceiveBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterCfg that = (ClusterCfg)o;
        return this.port == that.port && Objects.equals(this.initialContactPoints, that.initialContactPoints) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.memberId, that.memberId) && Objects.equals(this.host, that.host) && Objects.equals(this.membership, that.membership) && Objects.equals(this.security, that.security) && Objects.equals(this.messageCompression, that.messageCompression) && Objects.equals(this.configManager, that.configManager) && Objects.equals(this.socketSendBuffer, that.socketSendBuffer) && Objects.equals(this.socketReceiveBuffer, that.socketReceiveBuffer);
    }

    public String toString() {
        return "ClusterCfg{initialContactPoints=" + String.valueOf(this.initialContactPoints) + ", requestTimeout=" + String.valueOf(this.requestTimeout) + ", clusterName='" + this.clusterName + "', memberId='" + this.memberId + "', host='" + this.host + "', port=" + this.port + ", membership=" + String.valueOf(this.membership) + ", security=" + String.valueOf(this.security) + ", messageCompression=" + String.valueOf(this.messageCompression) + ", configManagerCfg=" + String.valueOf(this.configManager) + ", socketSendBuffer=" + String.valueOf(this.socketSendBuffer) + ", socketReceiveBuffer=" + String.valueOf(this.socketReceiveBuffer) + "}";
    }
}

