/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationMappingInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceMigrationRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceMigrationIntent;
import java.util.List;
import org.agrona.DirectBuffer;

public final class BrokerMigrateProcessInstanceRequest
extends BrokerExecuteCommand<ProcessInstanceMigrationRecord> {
    private final ProcessInstanceMigrationRecord requestDto = new ProcessInstanceMigrationRecord();

    public BrokerMigrateProcessInstanceRequest() {
        super(ValueType.PROCESS_INSTANCE_MIGRATION, (Intent)ProcessInstanceMigrationIntent.MIGRATE);
    }

    public BrokerMigrateProcessInstanceRequest setProcessInstanceKey(long processInstanceKey) {
        this.requestDto.setProcessInstanceKey(processInstanceKey);
        this.request.setKey(processInstanceKey);
        return this;
    }

    public BrokerMigrateProcessInstanceRequest setTargetProcessDefinitionKey(long targetProcessDefinitionKey) {
        this.requestDto.setTargetProcessDefinitionKey(targetProcessDefinitionKey);
        return this;
    }

    public BrokerMigrateProcessInstanceRequest addMappingInstructions(List<GatewayOuterClass.MigrateProcessInstanceRequest.MappingInstruction> mappingInstructions) {
        mappingInstructions.stream().map(mappingInstruction -> new ProcessInstanceMigrationMappingInstruction().setSourceElementId(mappingInstruction.getSourceElementId()).setTargetElementId(mappingInstruction.getTargetElementId())).forEach(arg_0 -> ((ProcessInstanceMigrationRecord)this.requestDto).addMappingInstruction(arg_0));
        return this;
    }

    public BrokerMigrateProcessInstanceRequest setMappingInstructions(List<ProcessInstanceMigrationMappingInstruction> mappingInstructions) {
        mappingInstructions.forEach(arg_0 -> ((ProcessInstanceMigrationRecord)this.requestDto).addMappingInstruction(arg_0));
        return this;
    }

    public ProcessInstanceMigrationRecord getRequestWriter() {
        return this.requestDto;
    }

    protected ProcessInstanceMigrationRecord toResponseDto(DirectBuffer buffer) {
        ProcessInstanceMigrationRecord responseDto = new ProcessInstanceMigrationRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }
}

