/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.cmd;

import io.camunda.zeebe.gateway.cmd.ClientException;
import java.util.List;

public class InvalidTenantRequestException
extends ClientException {
    private static final String MESSAGE_FORMAT = "Expected to handle request %s with tenant identifier '%s', but %s";
    private static final String MESSAGE_FORMAT_TENANTS = "Expected to handle request %s with tenant identifiers '%s', but %s";
    private final String commandName;
    private final String tenantId;
    private final List<String> tenantIds;
    private final String reason;

    public InvalidTenantRequestException(String commandName, String tenantId, String reason) {
        super(String.format(MESSAGE_FORMAT, commandName, tenantId, reason));
        this.commandName = commandName;
        this.tenantId = tenantId;
        this.tenantIds = List.of();
        this.reason = reason;
    }

    public InvalidTenantRequestException(String commandName, String tenantId, String reason, Exception e) {
        super(String.format(MESSAGE_FORMAT, commandName, tenantId, reason), e);
        this.commandName = commandName;
        this.tenantId = tenantId;
        this.tenantIds = List.of();
        this.reason = reason;
    }

    public InvalidTenantRequestException(String commandName, List<String> tenantIds, String reason) {
        super(String.format(MESSAGE_FORMAT_TENANTS, commandName, tenantIds.toString(), reason));
        this.commandName = commandName;
        this.tenantId = "";
        this.tenantIds = tenantIds;
        this.reason = reason;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public String getReason() {
        return this.reason;
    }

    public String getTenantId() {
        return this.tenantId;
    }
}

