/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.metrics;

import io.camunda.zeebe.gateway.metrics.LongPollingMetricsDoc;
import io.camunda.zeebe.util.micrometer.BoundedMeterCache;
import io.camunda.zeebe.util.micrometer.StatefulGauge;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;

public sealed class LongPollingMetrics {
    private final BoundedMeterCache<StatefulGauge> requestsQueued;

    public LongPollingMetrics(MeterRegistry registry, LongPollingMetricsDoc.GatewayProtocol gatewayProtocol) {
        Meter.MeterProvider provider = StatefulGauge.builder((String)LongPollingMetricsDoc.REQUESTS_QUEUED_CURRENT.getName()).description(LongPollingMetricsDoc.REQUESTS_QUEUED_CURRENT.getDescription()).tag(LongPollingMetricsDoc.GatewayKeyNames.GATEWAY_PROTOCOL.asString(), gatewayProtocol.value()).withRegistry(registry);
        this.requestsQueued = BoundedMeterCache.of((MeterRegistry)registry, (Meter.MeterProvider)provider, (KeyName)LongPollingMetricsDoc.RequestsQueuedKeyNames.TYPE);
    }

    protected LongPollingMetrics(BoundedMeterCache<StatefulGauge> requestsQueued) {
        this.requestsQueued = requestsQueued;
    }

    public static LongPollingMetrics noop() {
        return new Noop();
    }

    public void setBlockedRequestsCount(String type, int count) {
        ((StatefulGauge)this.requestsQueued.get(type)).set((long)count);
    }

    private static final class Noop
    extends LongPollingMetrics {
        private Noop() {
            super(null);
        }

        @Override
        public void setBlockedRequestsCount(String type, int count) {
        }
    }
}

