/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.HashSet;
import org.agrona.DirectBuffer;

public class BrokerUpdateJobRequest
extends BrokerExecuteCommand<JobRecord> {
    private final JobRecord requestDto = new JobRecord();

    public BrokerUpdateJobRequest(long jobKey, Integer retries, Long timeout) {
        super(ValueType.JOB, (Intent)JobIntent.UPDATE);
        this.request.setKey(jobKey);
        HashSet<String> changedAttributes = new HashSet<String>();
        if (retries != null) {
            this.requestDto.setRetries(retries.intValue());
            changedAttributes.add("retries");
        }
        if (timeout != null) {
            this.requestDto.setTimeout(timeout.longValue());
            changedAttributes.add("timeout");
        }
        this.requestDto.setChangedAttributes(changedAttributes);
    }

    public BufferWriter getRequestWriter() {
        return this.requestDto;
    }

    protected JobRecord toResponseDto(DirectBuffer buffer) {
        JobRecord responseDto = new JobRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }
}

