/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.configuration;

import io.camunda.zeebe.gateway.impl.configuration.ConfigurationDefaults;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import org.springframework.util.unit.DataSize;

public final class NetworkCfg {
    private String host;
    private int port = 26500;
    private Duration minKeepAliveInterval = Duration.ofSeconds(30L);
    private DataSize maxMessageSize = DataSize.ofMegabytes((long)4L);
    private DataSize socketSendBuffer = ConfigurationDefaults.DEFAULT_GATEWAY_SOCKET_SEND_BUFFER;
    private DataSize socketReceiveBuffer = ConfigurationDefaults.DEFAULT_GATEWAY_SOCKET_RECEIVE_BUFFER;

    public void init(String defaultHost) {
        if (this.host == null) {
            this.host = defaultHost;
        }
    }

    public String getHost() {
        return this.host;
    }

    public NetworkCfg setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NetworkCfg setPort(int port) {
        this.port = port;
        return this;
    }

    public Duration getMinKeepAliveInterval() {
        return this.minKeepAliveInterval;
    }

    public NetworkCfg setMinKeepAliveInterval(Duration keepAlive) {
        this.minKeepAliveInterval = keepAlive;
        return this;
    }

    public DataSize getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public NetworkCfg setMaxMessageSize(DataSize maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public DataSize getSocketSendBuffer() {
        return this.socketSendBuffer;
    }

    public NetworkCfg setSocketSendBuffer(DataSize socketSendBuffer) {
        this.socketSendBuffer = socketSendBuffer;
        return this;
    }

    public DataSize getSocketReceiveBuffer() {
        return this.socketReceiveBuffer;
    }

    public NetworkCfg setSocketReceiveBuffer(DataSize socketReceiveBuffer) {
        this.socketReceiveBuffer = socketReceiveBuffer;
        return this;
    }

    public InetSocketAddress toSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.socketSendBuffer, this.socketReceiveBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkCfg that = (NetworkCfg)o;
        return this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.socketReceiveBuffer, that.socketReceiveBuffer) && Objects.equals(this.socketSendBuffer, that.socketSendBuffer);
    }

    public String toString() {
        return "NetworkCfg{host='" + this.host + "', port=" + this.port + ", minKeepAliveInterval=" + String.valueOf(this.minKeepAliveInterval) + ", socketReceiveBuffer=" + String.valueOf(this.socketReceiveBuffer) + ", socketSendBuffer=" + String.valueOf(this.socketSendBuffer) + "}";
    }
}

