/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request.group;

import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.protocol.impl.record.value.group.GroupRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.GroupIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.EntityType;
import org.agrona.DirectBuffer;

public class BrokerGroupMemberRequest
extends BrokerExecuteCommand<GroupRecord> {
    private final GroupRecord requestDto = new GroupRecord();

    public BrokerGroupMemberRequest(String groupId, GroupIntent intent) {
        super(ValueType.GROUP, (Intent)intent);
        long key = Long.parseLong(groupId);
        this.request.setKey(key);
        this.requestDto.setGroupKey(key);
    }

    public static BrokerGroupMemberRequest createAddRequest(String groupId) {
        return new BrokerGroupMemberRequest(groupId, GroupIntent.ADD_ENTITY);
    }

    public static BrokerGroupMemberRequest createRemoveRequest(String groupId) {
        return new BrokerGroupMemberRequest(groupId, GroupIntent.REMOVE_ENTITY);
    }

    public BrokerGroupMemberRequest setMemberId(String memberKey) {
        this.requestDto.setEntityId(memberKey);
        return this;
    }

    public BrokerGroupMemberRequest setMemberType(EntityType memberType) {
        this.requestDto.setEntityType(memberType);
        return this;
    }

    public GroupRecord getRequestWriter() {
        return this.requestDto;
    }

    protected GroupRecord toResponseDto(DirectBuffer buffer) {
        GroupRecord response = new GroupRecord();
        response.wrap(buffer);
        return response;
    }
}

