/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.protocol.impl.record.value.tenant.TenantRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TenantIntent;
import io.camunda.zeebe.protocol.record.value.EntityType;
import java.util.EnumSet;
import java.util.Set;
import org.agrona.DirectBuffer;

public final class BrokerTenantEntityRequest
extends BrokerExecuteCommand<TenantRecord> {
    private static final Set<EntityType> ALLOWED_ENTITY_TYPES = EnumSet.of(EntityType.USER, EntityType.MAPPING, EntityType.GROUP);
    private final TenantRecord tenantDto = new TenantRecord();

    private BrokerTenantEntityRequest(TenantIntent intent) {
        super(ValueType.TENANT, (Intent)intent);
    }

    public static BrokerTenantEntityRequest createAddRequest() {
        return new BrokerTenantEntityRequest(TenantIntent.ADD_ENTITY);
    }

    public static BrokerTenantEntityRequest createRemoveRequest() {
        return new BrokerTenantEntityRequest(TenantIntent.REMOVE_ENTITY);
    }

    public BrokerTenantEntityRequest setTenantKey(long tenantKey) {
        this.tenantDto.setTenantKey(tenantKey);
        return this;
    }

    public BrokerTenantEntityRequest setTenantId(String tenantId) {
        this.tenantDto.setTenantId(tenantId);
        return this;
    }

    public BrokerTenantEntityRequest setEntity(EntityType entityType, String entityId) {
        if (!ALLOWED_ENTITY_TYPES.contains(entityType)) {
            throw new IllegalArgumentException("For now, tenants can only be assigned to %s".formatted(ALLOWED_ENTITY_TYPES));
        }
        this.tenantDto.setEntityType(entityType);
        this.tenantDto.setEntityId(entityId);
        return this;
    }

    public TenantRecord getRequestWriter() {
        return this.tenantDto;
    }

    protected TenantRecord toResponseDto(DirectBuffer buffer) {
        TenantRecord response = new TenantRecord();
        response.wrap(buffer);
        return response;
    }
}

