/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.broker.request;

import io.camunda.zeebe.broker.client.api.dto.BrokerExecuteCommand;
import io.camunda.zeebe.protocol.impl.record.value.authorization.RoleRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.RoleIntent;
import io.camunda.zeebe.protocol.record.value.EntityType;
import org.agrona.DirectBuffer;

public final class BrokerRoleEntityRequest
extends BrokerExecuteCommand<RoleRecord> {
    private final RoleRecord roleDto = new RoleRecord();

    private BrokerRoleEntityRequest(RoleIntent intent) {
        super(ValueType.ROLE, (Intent)intent);
        this.setPartitionId(1);
    }

    public static BrokerRoleEntityRequest createAddRequest() {
        return new BrokerRoleEntityRequest(RoleIntent.ADD_ENTITY);
    }

    public static BrokerRoleEntityRequest createRemoveRequest() {
        return new BrokerRoleEntityRequest(RoleIntent.REMOVE_ENTITY);
    }

    public BrokerRoleEntityRequest setRoleId(String roleId) {
        this.roleDto.setRoleId(roleId);
        return this;
    }

    public BrokerRoleEntityRequest setEntity(EntityType entityType, String entityId) {
        if (entityType != EntityType.USER && entityType != EntityType.MAPPING) {
            throw new IllegalArgumentException("For now, roles can only be granted to users and mappings");
        }
        this.roleDto.setEntityType(entityType);
        this.roleDto.setEntityId(entityId);
        return this;
    }

    public RoleRecord getRequestWriter() {
        return this.roleDto;
    }

    protected RoleRecord toResponseDto(DirectBuffer buffer) {
        RoleRecord response = new RoleRecord();
        response.wrap(buffer);
        return response;
    }
}

