/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.api.util;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.broker.client.api.BrokerTopologyListener;
import io.camunda.zeebe.broker.client.api.BrokerTopologyManager;
import io.camunda.zeebe.broker.client.impl.BrokerClusterStateImpl;
import io.camunda.zeebe.dynamic.config.state.ClusterConfiguration;

public final class StubbedTopologyManager
implements BrokerTopologyManager {
    private final BrokerClusterStateImpl clusterState;
    private final ClusterConfiguration clusterConfiguration = ClusterConfiguration.uninitialized();

    StubbedTopologyManager() {
        this(8);
    }

    StubbedTopologyManager(int partitionsCount) {
        this.clusterState = new BrokerClusterStateImpl();
        this.clusterState.setClusterSize(1);
        this.clusterState.addBrokerIfAbsent(0);
        this.clusterState.setBrokerAddressIfPresent(0, "localhost:26501");
        for (int partitionOffset = 0; partitionOffset < partitionsCount; ++partitionOffset) {
            this.clusterState.setPartitionLeader(1 + partitionOffset, 0, 1L);
            this.clusterState.addPartitionIfAbsent(1 + partitionOffset);
        }
        this.clusterState.setPartitionsCount(partitionsCount);
    }

    public BrokerClusterState getTopology() {
        return this.clusterState;
    }

    public ClusterConfiguration getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    public void addTopologyListener(BrokerTopologyListener listener) {
        throw new UnsupportedOperationException("Not yet implemented; implement if need be");
    }

    public void removeTopologyListener(BrokerTopologyListener listener) {
        throw new UnsupportedOperationException("Not yet implemented; implement if need be");
    }

    public void onClusterConfigurationUpdated(ClusterConfiguration clusterConfiguration) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

