/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.query.impl;

import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.client.api.dto.BrokerRequest;
import io.camunda.zeebe.gateway.query.QueryApi;
import io.camunda.zeebe.gateway.query.impl.BrokerExecuteQuery;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.record.ValueType;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class QueryApiImpl
implements QueryApi {
    private final BrokerClient client;

    public QueryApiImpl(BrokerClient client) {
        this.client = client;
    }

    @Override
    public CompletionStage<String> getBpmnProcessIdFromProcess(long key, Duration timeout) {
        return this.queryPartition(key, ValueType.PROCESS, timeout);
    }

    @Override
    public CompletionStage<String> getBpmnProcessIdFromProcessInstance(long key, Duration timeout) {
        return this.queryPartition(key, ValueType.PROCESS_INSTANCE, timeout);
    }

    @Override
    public CompletionStage<String> getBpmnProcessIdFromJob(long key, Duration timeout) {
        return this.queryPartition(key, ValueType.JOB, timeout);
    }

    private CompletionStage<String> queryPartition(long key, ValueType valueType, Duration timeout) {
        CompletableFuture<String> result = new CompletableFuture<String>();
        try {
            this.sendRequest(key, valueType, timeout, result);
        }
        catch (Exception e) {
            result.completeExceptionally(e);
        }
        return result;
    }

    private void sendRequest(long key, ValueType valueType, Duration timeout, CompletableFuture<String> result) {
        BrokerExecuteQuery request = new BrokerExecuteQuery();
        int partitionId = Protocol.decodePartitionId((long)key);
        request.setKey(key);
        request.setPartitionId(partitionId);
        request.setValueType(valueType);
        this.client.sendRequestWithRetry((BrokerRequest)request, timeout).whenComplete((response, error) -> {
            if (error != null) {
                result.completeExceptionally((Throwable)error);
            } else {
                result.complete((String)response.getResponse());
            }
        });
    }
}

