/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.metrics;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

public final class LongPollingMetrics {
    private final Map<String, AtomicLong> requestsQueued = new HashMap<String, AtomicLong>();
    private final MeterRegistry registry;

    public LongPollingMetrics(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "must specify a meter registry");
    }

    public void setBlockedRequestsCount(String type, int count) {
        this.requestsQueued.computeIfAbsent(type, this::registerBlockedRequestsCount).set(count);
    }

    private AtomicLong registerBlockedRequestsCount(String type) {
        AtomicLong count = new AtomicLong();
        Gauge.builder((String)LongPollingMetricsDoc.REQUESTS_QUEUED_CURRENT.getName(), (Object)count, Number::longValue).description(LongPollingMetricsDoc.REQUESTS_QUEUED_CURRENT.getDescription()).tag(RequestsQueuedKeyNames.TYPE.asString(), type).register(this.registry);
        return count;
    }

    public static enum LongPollingMetricsDoc implements ExtendedMeterDocumentation
    {
        REQUESTS_QUEUED_CURRENT{

            public String getDescription() {
                return "Number of requests currently queued due to long polling";
            }

            public String getName() {
                return "zeebe.long.polling.queued.current";
            }

            public Meter.Type getType() {
                return Meter.Type.GAUGE;
            }

            public KeyName[] getKeyNames() {
                return RequestsQueuedKeyNames.values();
            }
        };

    }

    public static enum RequestsQueuedKeyNames implements KeyName
    {
        TYPE{

            public String asString() {
                return "type";
            }
        };

    }
}

