/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.interceptors.impl;

import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.impl.configuration.InterceptorCfg;
import io.camunda.zeebe.gateway.interceptors.impl.InterceptorLoadException;
import io.camunda.zeebe.util.ReflectUtil;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import io.camunda.zeebe.util.jar.ExternalJarRepository;
import io.grpc.ServerInterceptor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.slf4j.Logger;

public final class InterceptorRepository {
    private static final Logger LOGGER = Loggers.GATEWAY_LOGGER;
    private final ExternalJarRepository jarRepository;
    private final SortedMap<InterceptorId, Class<? extends ServerInterceptor>> interceptors;
    private final Path basePath;

    public InterceptorRepository() {
        this(new TreeMap<InterceptorId, Class<? extends ServerInterceptor>>(), new ExternalJarRepository(), Paths.get(Optional.ofNullable(System.getProperty("basedir")).orElse("."), new String[0]));
    }

    InterceptorRepository(SortedMap<InterceptorId, Class<? extends ServerInterceptor>> interceptors, ExternalJarRepository jarRepository, Path basePath) {
        this.interceptors = interceptors;
        this.jarRepository = jarRepository;
        this.basePath = basePath;
    }

    public SortedMap<InterceptorId, Class<? extends ServerInterceptor>> getInterceptors() {
        return Collections.unmodifiableSortedMap(this.interceptors);
    }

    public Stream<ServerInterceptor> instantiate() {
        return this.interceptors.entrySet().stream().map(entry -> this.instantiate(((InterceptorId)entry.getKey()).id, (Class)entry.getValue()));
    }

    public InterceptorRepository load(List<? extends InterceptorCfg> configs) {
        IntStream.range(0, configs.size()).forEach(i -> {
            InterceptorCfg config = (InterceptorCfg)configs.get(i);
            try {
                this.load(i, config);
            }
            catch (Exception e) {
                LOGGER.debug("Failed to load interceptor {} with config {}", (Object)config.getId(), (Object)config);
                LangUtil.rethrowUnchecked((Throwable)e);
            }
        });
        return this;
    }

    Class<? extends ServerInterceptor> load(int order, InterceptorCfg config) throws ExternalJarLoadException {
        Class<ServerInterceptor> interceptorClass;
        ClassLoader classLoader;
        String id = config.getId();
        InterceptorId interceptorId = new InterceptorId(id, order);
        if (this.interceptors.containsKey(interceptorId)) {
            return (Class)this.interceptors.get(interceptorId);
        }
        if (!config.isExternal()) {
            classLoader = this.getClass().getClassLoader();
        } else {
            Path jarPath = this.basePath.resolve(config.getJarPath());
            classLoader = this.jarRepository.load(jarPath);
        }
        try {
            Class<?> specifiedClass = classLoader.loadClass(config.getClassName());
            interceptorClass = specifiedClass.asSubclass(ServerInterceptor.class);
        }
        catch (ClassNotFoundException e) {
            throw new InterceptorLoadException(id, "cannot load specified class", e);
        }
        catch (ClassCastException e) {
            throw new InterceptorLoadException(id, "specified class does not implement ServerInterceptor", e);
        }
        this.put(interceptorId, interceptorClass);
        return interceptorClass;
    }

    private void put(InterceptorId id, Class<? extends ServerInterceptor> interceptorClass) {
        this.interceptors.put(id, interceptorClass);
    }

    private ServerInterceptor instantiate(String id, Class<? extends ServerInterceptor> interceptorClass) {
        try {
            return (ServerInterceptor)ReflectUtil.newInstance(interceptorClass);
        }
        catch (Exception e) {
            throw new InterceptorLoadException(id, "cannot instantiate via the default constructor", e);
        }
    }

    public record InterceptorId(String id, int order) implements Comparable<InterceptorId>
    {
        @Override
        public int compareTo(InterceptorId o) {
            return Comparator.comparingInt(InterceptorId::order).compare(this, o);
        }
    }
}

