/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.interceptors.impl;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.identity.sdk.authentication.exception.TokenVerificationException;
import io.camunda.identity.sdk.tenants.dto.Tenant;
import io.camunda.zeebe.gateway.cmd.ConcurrentRequestException;
import io.camunda.zeebe.gateway.impl.configuration.GatewayCfg;
import io.camunda.zeebe.gateway.impl.configuration.IdentityCfg;
import io.camunda.zeebe.gateway.impl.configuration.IdentityServiceCfg;
import io.camunda.zeebe.gateway.impl.configuration.MultiTenancyCfg;
import io.camunda.zeebe.gateway.impl.identity.IdentityTenantService;
import io.camunda.zeebe.gateway.interceptors.InterceptorUtil;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IdentityInterceptor
implements ServerInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityInterceptor.class);
    private static final Metadata.Key<String> AUTH_KEY = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final Identity identity;
    private final IdentityTenantService tenantService;
    private final MultiTenancyCfg multiTenancy;

    public IdentityInterceptor(IdentityCfg config, GatewayCfg gatewayCfg) {
        this(IdentityInterceptor.createIdentity(config), gatewayCfg.getMultiTenancy(), gatewayCfg.getExperimental().getIdentityRequest());
    }

    public IdentityInterceptor(IdentityConfiguration configuration, GatewayCfg gatewayCfg) {
        this(new Identity(configuration), gatewayCfg.getMultiTenancy(), gatewayCfg.getExperimental().getIdentityRequest());
    }

    public IdentityInterceptor(Identity identity, MultiTenancyCfg multiTenancy, IdentityServiceCfg identityServiceCfg) {
        this.identity = identity;
        this.multiTenancy = multiTenancy;
        this.tenantService = new IdentityTenantService(identity, identityServiceCfg);
    }

    private static Identity createIdentity(IdentityCfg config) {
        return new Identity(new IdentityConfiguration.Builder().withIssuerBackendUrl(config.getIssuerBackendUrl()).withAudience(config.getAudience()).withType(config.getType().name()).withBaseUrl(config.getBaseUrl()).build());
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        MethodDescriptor methodDescriptor = call.getMethodDescriptor();
        String authorization = (String)headers.get(AUTH_KEY);
        if (authorization == null) {
            LOGGER.debug("Denying call {} as no token was provided", (Object)methodDescriptor.getFullMethodName());
            return this.deny(call, Status.UNAUTHENTICATED.augmentDescription("Expected bearer token at header with key [%s], but found nothing".formatted(AUTH_KEY.name())));
        }
        String token = authorization.replaceFirst("^Bearer ", "");
        try {
            this.identity.authentication().verifyToken(token);
        }
        catch (TokenVerificationException e) {
            LOGGER.debug("Denying call {} as the token could not be verified successfully. Error message: {}", new Object[]{methodDescriptor.getFullMethodName(), e.getMessage(), e});
            return this.deny(call, Status.UNAUTHENTICATED.augmentDescription("Failed to parse bearer token, see cause for details").withCause((Throwable)e));
        }
        if (!this.multiTenancy.isEnabled()) {
            return next.startCall(call, headers);
        }
        try {
            List<String> authorizedTenants = this.tenantService.getTenantsForToken(token).stream().map(Tenant::getTenantId).toList();
            Context context = InterceptorUtil.setAuthorizedTenants(authorizedTenants);
            return Contexts.interceptCall((Context)context, call, (Metadata)headers, next);
        }
        catch (ConcurrentRequestException cre) {
            return this.denyTenantCallAndLog(call, Status.UNAVAILABLE, cre);
        }
        catch (RuntimeException | ExecutionException e) {
            return this.denyTenantCallAndLog(call, Status.UNAUTHENTICATED, e);
        }
    }

    private <ReqT> ServerCall.Listener<ReqT> denyTenantCallAndLog(ServerCall<ReqT, ?> call, Status status, Throwable ex) {
        LOGGER.debug("Denying call {} as the authorized tenants could not be retrieved from Identity. Error message: {}", (Object)call.getMethodDescriptor().getFullMethodName(), (Object)ex.getMessage());
        return this.deny(call, status.augmentDescription("Expected Identity to provide authorized tenants, see cause for details").withCause(ex));
    }

    private <ReqT> ServerCall.Listener<ReqT> deny(ServerCall<ReqT, ?> call, Status status) {
        call.close(status, new Metadata());
        return new ServerCall.Listener<ReqT>(this){};
    }
}

