/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.stream;

import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.micrometer.common.docs.KeyName;
import io.micrometer.core.instrument.Meter;

public enum JobClientStreamMetricsDoc implements ExtendedMeterDocumentation
{
    SERVERS{

        public String getDescription() {
            return "The count of known job stream servers/brokers";
        }

        public String getName() {
            return "zeebe.gateway.job.stream.servers";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }
    }
    ,
    CLIENTS{

        public String getDescription() {
            return "The count of known job stream clients";
        }

        public String getName() {
            return "zeebe.gateway.job.stream.clients";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }
    }
    ,
    AGGREGATED_STREAMS{

        public String getDescription() {
            return "Total count of aggregated streams";
        }

        public String getName() {
            return "zeebe.gateway.job.stream.streams";
        }

        public Meter.Type getType() {
            return Meter.Type.GAUGE;
        }
    }
    ,
    AGGREGATED_CLIENTS{
        private static final double[] BUCKETS = new double[]{0.005, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0};

        public String getDescription() {
            return "Distribution of client count per aggregated stream";
        }

        public String getName() {
            return "zeebe.gateway.job.stream.aggregated.stream.clients";
        }

        public Meter.Type getType() {
            return Meter.Type.DISTRIBUTION_SUMMARY;
        }

        public double[] getDistributionSLOs() {
            return BUCKETS;
        }
    }
    ,
    PUSHES{

        public String getDescription() {
            return "Count of pushed payloads, tagged by result status (success, failure)";
        }

        public String getName() {
            return "zeebe.gateway.job.stream.push";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{PushKeyNames.STATUS};
        }
    }
    ,
    PUSH_TRY_FAILED_COUNT{

        public String getDescription() {
            return "Total number of failed attempts when pushing jobs to the clients, grouped by code";
        }

        public String getName() {
            return "zeebe.gateway.job.stream.";
        }

        public Meter.Type getType() {
            return Meter.Type.COUNTER;
        }

        public KeyName[] getKeyNames() {
            return new KeyName[]{PushKeyNames.CODE};
        }
    };


    public static enum PushResultTag {
        SUCCESS("success"),
        FAILURE("failure");

        private final String tagValue;

        private PushResultTag(String tagValue) {
            this.tagValue = tagValue;
        }

        public String getTagValue() {
            return this.tagValue;
        }
    }

    public static enum PushKeyNames implements KeyName
    {
        STATUS{

            public String asString() {
                return "status";
            }
        }
        ,
        CODE{

            public String asString() {
                return "code";
            }
        };

    }
}

