/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.stream;

import io.camunda.zeebe.gateway.impl.stream.JobClientStreamMetricsDoc;
import io.camunda.zeebe.transport.stream.api.ClientStreamMetrics;
import io.camunda.zeebe.transport.stream.impl.messages.ErrorCode;
import io.camunda.zeebe.util.micrometer.ExtendedMeterDocumentation;
import io.camunda.zeebe.util.micrometer.MicrometerUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

final class JobClientStreamMetrics
implements ClientStreamMetrics {
    private final AtomicLong serverCount = new AtomicLong();
    private final AtomicLong clientCount = new AtomicLong();
    private final AtomicLong aggregatedStreamCount = new AtomicLong();
    private final Map<ErrorCode, Counter> pushAttempts = new EnumMap<ErrorCode, Counter>(ErrorCode.class);
    private final DistributionSummary aggregatedClients;
    private final Counter pushSuccessCount;
    private final Counter pushFailureCount;

    JobClientStreamMetrics(MeterRegistry registry) {
        this.aggregatedClients = MicrometerUtil.summary((ExtendedMeterDocumentation)JobClientStreamMetricsDoc.AGGREGATED_CLIENTS).register(registry);
        this.pushFailureCount = this.registerPushCounter(JobClientStreamMetricsDoc.PUSHES, JobClientStreamMetricsDoc.PushResultTag.FAILURE, registry);
        this.pushSuccessCount = this.registerPushCounter(JobClientStreamMetricsDoc.PUSHES, JobClientStreamMetricsDoc.PushResultTag.SUCCESS, registry);
        this.registerGauge(JobClientStreamMetricsDoc.SERVERS, this.serverCount, registry);
        this.registerGauge(JobClientStreamMetricsDoc.CLIENTS, this.clientCount, registry);
        this.registerGauge(JobClientStreamMetricsDoc.AGGREGATED_STREAMS, this.aggregatedStreamCount, registry);
        for (ErrorCode errorCode : ErrorCode.values()) {
            this.pushAttempts.put(errorCode, this.registerPushAttemptCounter(registry, errorCode));
        }
    }

    public void serverCount(int count) {
        this.serverCount.set(count);
    }

    public void clientCount(int count) {
        this.clientCount.set(count);
    }

    public void aggregatedStreamCount(int count) {
        this.aggregatedStreamCount.set(count);
    }

    public void observeAggregatedClientCount(int count) {
        this.aggregatedClients.record((double)count);
    }

    public void pushSucceeded() {
        this.pushSuccessCount.increment();
    }

    public void pushFailed() {
        this.pushFailureCount.increment();
    }

    public void pushTryFailed(ErrorCode code) {
        this.pushAttempts.get(code).increment();
    }

    private void registerGauge(JobClientStreamMetricsDoc doc, AtomicLong state, MeterRegistry registry) {
        Gauge.builder((String)doc.getName(), (Object)state, AtomicLong::get).description(doc.getDescription()).register(registry);
    }

    private Counter registerPushAttemptCounter(MeterRegistry registry, ErrorCode errorCode) {
        return Counter.builder((String)JobClientStreamMetricsDoc.PUSH_TRY_FAILED_COUNT.getName()).description(JobClientStreamMetricsDoc.PUSH_TRY_FAILED_COUNT.getDescription()).tag(JobClientStreamMetricsDoc.PushKeyNames.CODE.asString(), errorCode.name()).register(registry);
    }

    private Counter registerPushCounter(JobClientStreamMetricsDoc doc, JobClientStreamMetricsDoc.PushResultTag result, MeterRegistry registry) {
        return Counter.builder((String)doc.getName()).description(doc.getDescription()).tag(JobClientStreamMetricsDoc.PushKeyNames.STATUS.asString(), result.getTagValue()).register(registry);
    }
}

