/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.probes.health;

import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.health.Status;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class StartedHealthIndicator
implements HealthIndicator {
    public static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private final Supplier<Optional<Status>> gatewayStatusSupplier;

    public StartedHealthIndicator(Supplier<Optional<Status>> gatewayStatusSupplier) {
        this.gatewayStatusSupplier = Objects.requireNonNull(gatewayStatusSupplier);
    }

    public Health health() {
        Optional<Status> optStatus = this.gatewayStatusSupplier.get();
        if (optStatus.isEmpty()) {
            return Health.unknown().build();
        }
        Status status = optStatus.get();
        switch (status) {
            case INITIAL: 
            case STARTING: {
                return Health.down().build();
            }
            case RUNNING: {
                return Health.up().build();
            }
            case SHUTDOWN: {
                return Health.outOfService().build();
            }
        }
        LOG.warn("Encountered unexpected status " + String.valueOf((Object)status));
        return Health.unknown().build();
    }
}

