/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.probes.health;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class PartitionLeaderAwarenessHealthIndicator
implements HealthIndicator {
    private final Supplier<Optional<BrokerClusterState>> clusterStateSupplier;

    public PartitionLeaderAwarenessHealthIndicator(Supplier<Optional<BrokerClusterState>> clusterStateSupplier) {
        this.clusterStateSupplier = Objects.requireNonNull(clusterStateSupplier);
    }

    public Health health() {
        Optional<BrokerClusterState> optClusterState = this.clusterStateSupplier.get();
        if (optClusterState.isEmpty()) {
            return Health.down().build();
        }
        BrokerClusterState clusterState = optClusterState.get();
        if (clusterState.getPartitions().stream().anyMatch(index -> clusterState.getLeaderForPartition(index.intValue()) != -2)) {
            return Health.up().build();
        }
        return Health.down().build();
    }
}

