/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.probes.health;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.protocol.record.PartitionHealthStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class ClusterHealthIndicator
implements HealthIndicator {
    private final Supplier<Optional<BrokerClusterState>> clusterStateSupplier;

    public ClusterHealthIndicator(Supplier<Optional<BrokerClusterState>> clusterStateSupplier) {
        this.clusterStateSupplier = Objects.requireNonNull(clusterStateSupplier);
    }

    public Health health() {
        Optional<BrokerClusterState> optClusterState = this.clusterStateSupplier.get();
        if (optClusterState.isEmpty()) {
            return Health.down().build();
        }
        if (optClusterState.get().getBrokers().isEmpty()) {
            return Health.down().build();
        }
        if (!optClusterState.get().getPartitions().isEmpty()) {
            List partitions = optClusterState.get().getPartitions();
            Map<String, PartitionHealthStatus> partitionDetails = this.getPartitionsHealthStatus(partitions, optClusterState.get());
            return this.getStatus(partitions.size(), partitionDetails);
        }
        return Health.down().build();
    }

    Map<String, PartitionHealthStatus> getPartitionsHealthStatus(List<Integer> partitions, BrokerClusterState optClusterState) {
        HashMap<String, PartitionHealthStatus> partitionDetails = new HashMap<String, PartitionHealthStatus>();
        partitions.forEach(partition -> {
            int broker = optClusterState.getLeaderForPartition(partition.intValue());
            PartitionHealthStatus partitionHealthStatus = optClusterState.getPartitionHealth(broker, partition.intValue());
            partitionDetails.put(String.format("Partition %d", partition), partitionHealthStatus);
        });
        return partitionDetails;
    }

    private Health getStatus(int partitionCount, Map<String, PartitionHealthStatus> partitionDetails) {
        boolean hasOnlyHealthyPartitions;
        long unhealthyPartitionsCount = partitionDetails.values().stream().filter(p -> p == PartitionHealthStatus.UNHEALTHY || p == PartitionHealthStatus.DEAD).count();
        long healthyPartitionsCount = partitionDetails.values().stream().filter(p -> p == PartitionHealthStatus.HEALTHY).count();
        boolean hasOnlyUnhealthyPartitions = unhealthyPartitionsCount == (long)partitionDetails.size();
        boolean bl = hasOnlyHealthyPartitions = healthyPartitionsCount == (long)partitionCount;
        if (hasOnlyUnhealthyPartitions) {
            return Health.down().withDetails(partitionDetails).build();
        }
        if (hasOnlyHealthyPartitions) {
            return Health.up().withDetails(partitionDetails).build();
        }
        return Health.status((String)"DEGRADED").withDetails(partitionDetails).build();
    }
}

