/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.job;

import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.grpc.ServerStreamObserver;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerActivateJobsRequest;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.scheduler.ScheduledTimer;
import io.camunda.zeebe.util.Either;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;

public class InflightActivateJobsRequest {
    private static final Logger LOG = Loggers.LONG_POLLING;
    private final long requestId;
    private final BrokerActivateJobsRequest request;
    private final ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver;
    private final String jobType;
    private final String worker;
    private final int maxJobsToActivate;
    private final Duration longPollingTimeout;
    private ScheduledTimer scheduledTimer;
    private boolean isTimedOut;
    private boolean isCompleted;
    private boolean isAborted;

    public InflightActivateJobsRequest(long requestId, BrokerActivateJobsRequest request, ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver, long requestTimeout) {
        this(requestId, request, responseObserver, request.getRequestWriter().getType(), request.getRequestWriter().getWorker(), request.getRequestWriter().getMaxJobsToActivate(), requestTimeout);
    }

    private InflightActivateJobsRequest(long requestId, BrokerActivateJobsRequest request, ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver, String jobType, String worker, int maxJobsToActivate, long longPollingTimeout) {
        this.requestId = requestId;
        this.request = request;
        this.responseObserver = responseObserver;
        this.jobType = jobType;
        this.worker = worker;
        this.maxJobsToActivate = maxJobsToActivate;
        this.longPollingTimeout = longPollingTimeout == 0L ? null : Duration.ofMillis(longPollingTimeout);
    }

    public void complete() {
        if (!this.isOpen()) {
            return;
        }
        this.cancelTimerIfScheduled();
        try {
            this.responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.warn("Failed to complete {}", (Object)this.request, (Object)e);
        }
        this.isCompleted = true;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public Either<Exception, Boolean> tryToSendActivatedJobs(GatewayOuterClass.ActivateJobsResponse activatedJobs) {
        if (this.isOpen()) {
            try {
                this.responseObserver.onNext(activatedJobs);
                return Either.right((Object)true);
            }
            catch (Exception e) {
                LOG.warn("Failed to send response to client.", (Throwable)e);
                return Either.left((Object)e);
            }
        }
        return Either.right((Object)false);
    }

    public void onError(Throwable error) {
        if (!this.isOpen()) {
            return;
        }
        this.cancelTimerIfScheduled();
        try {
            this.responseObserver.onError(error);
        }
        catch (Exception e) {
            LOG.warn("Failed to send terminating error to client.", (Throwable)e);
        }
        this.isAborted = true;
    }

    public void timeout() {
        this.complete();
        this.isTimedOut = true;
    }

    public boolean isCanceled() {
        return this.responseObserver.isCancelled();
    }

    public BrokerActivateJobsRequest getRequest() {
        return this.request;
    }

    public ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> getResponseObserver() {
        return this.responseObserver;
    }

    public String getType() {
        return this.jobType;
    }

    public String getWorker() {
        return this.worker;
    }

    public int getMaxJobsToActivate() {
        return this.maxJobsToActivate;
    }

    public void setScheduledTimer(ScheduledTimer scheduledTimer) {
        this.scheduledTimer = scheduledTimer;
    }

    public boolean hasScheduledTimer() {
        return this.scheduledTimer != null;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public Duration getLongPollingTimeout(Duration defaultTimeout) {
        if (this.longPollingTimeout == null) {
            return defaultTimeout;
        }
        return this.longPollingTimeout;
    }

    public boolean isLongPollingDisabled() {
        return this.longPollingTimeout != null && this.longPollingTimeout.isNegative();
    }

    private void cancelTimerIfScheduled() {
        if (this.hasScheduledTimer()) {
            this.scheduledTimer.cancel();
            this.scheduledTimer = null;
        }
    }

    public boolean isAborted() {
        return this.isAborted;
    }

    public boolean isOpen() {
        return !this.isCompleted() && !this.isCanceled() && !this.isAborted();
    }

    public int hashCode() {
        return Objects.hash(this.jobType, this.maxJobsToActivate, this.requestId, this.worker);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InflightActivateJobsRequest other = (InflightActivateJobsRequest)obj;
        return Objects.equals(this.jobType, other.jobType) && this.maxJobsToActivate == other.maxJobsToActivate && this.requestId == other.requestId && Objects.equals(this.worker, other.worker);
    }
}

