/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.job;

import io.camunda.zeebe.gateway.impl.job.InflightActivateJobsRequest;
import io.camunda.zeebe.gateway.metrics.LongPollingMetrics;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public final class InFlightLongPollingActivateJobsRequestsState {
    private final String jobType;
    private final LongPollingMetrics metrics;
    private final Queue<InflightActivateJobsRequest> activeRequests = new LinkedList<InflightActivateJobsRequest>();
    private final Queue<InflightActivateJobsRequest> pendingRequests = new LinkedList<InflightActivateJobsRequest>();
    private final Set<InflightActivateJobsRequest> activeRequestsToBeRepeated = new HashSet<InflightActivateJobsRequest>();
    private int failedAttempts;
    private long lastUpdatedTime;
    private final AtomicBoolean ongoingNotification = new AtomicBoolean(false);

    public InFlightLongPollingActivateJobsRequestsState(String jobType, LongPollingMetrics metrics) {
        this.jobType = jobType;
        this.metrics = metrics;
    }

    public void incrementFailedAttempts(long lastUpdatedTime) {
        ++this.failedAttempts;
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public boolean shouldAttempt(int attemptThreshold) {
        return this.failedAttempts < attemptThreshold;
    }

    public void resetFailedAttempts() {
        this.setFailedAttempts(0);
    }

    public int getFailedAttempts() {
        return this.failedAttempts;
    }

    public void setFailedAttempts(int failedAttempts) {
        this.failedAttempts = failedAttempts;
        if (failedAttempts == 0) {
            this.activeRequestsToBeRepeated.addAll(this.activeRequests);
        }
    }

    public long getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public void enqueueRequest(InflightActivateJobsRequest request) {
        if (!this.pendingRequests.contains(request)) {
            this.pendingRequests.offer(request);
        }
        this.removeObsoleteRequestsAndUpdateMetrics();
    }

    public Queue<InflightActivateJobsRequest> getPendingRequests() {
        this.removeObsoleteRequestsAndUpdateMetrics();
        return this.pendingRequests;
    }

    private void removeObsoleteRequestsAndUpdateMetrics() {
        this.pendingRequests.removeIf(this::isObsolete);
        this.activeRequests.removeIf(this::isObsolete);
        this.activeRequestsToBeRepeated.removeIf(this::isObsolete);
        this.metrics.setBlockedRequestsCount(this.jobType, this.pendingRequests.size());
    }

    private boolean isObsolete(InflightActivateJobsRequest request) {
        return request.isTimedOut() || request.isCanceled() || request.isCompleted() || request.isAborted();
    }

    public void removeRequest(InflightActivateJobsRequest request) {
        this.pendingRequests.remove(request);
        this.removeObsoleteRequestsAndUpdateMetrics();
    }

    public InflightActivateJobsRequest getNextPendingRequest() {
        this.removeObsoleteRequestsAndUpdateMetrics();
        InflightActivateJobsRequest request = this.pendingRequests.poll();
        this.metrics.setBlockedRequestsCount(this.jobType, this.pendingRequests.size());
        return request;
    }

    public void addActiveRequest(InflightActivateJobsRequest request) {
        this.activeRequests.offer(request);
        this.pendingRequests.remove(request);
        this.activeRequestsToBeRepeated.remove(request);
    }

    public void removeActiveRequest(InflightActivateJobsRequest request) {
        this.activeRequests.remove(request);
        this.activeRequestsToBeRepeated.remove(request);
    }

    public boolean hasActiveRequests() {
        this.removeObsoleteRequestsAndUpdateMetrics();
        return !this.activeRequests.isEmpty();
    }

    public boolean shouldBeRepeated(InflightActivateJobsRequest request) {
        return this.activeRequestsToBeRepeated.contains(request) && !request.isLongPollingDisabled();
    }

    public boolean shouldNotifyAndStartNotification() {
        return this.ongoingNotification.compareAndSet(false, true);
    }

    public void completeNotification() {
        this.ongoingNotification.set(false);
    }
}

