/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.identity;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.tenants.dto.Tenant;
import io.camunda.zeebe.gateway.cmd.ConcurrentRequestException;
import io.camunda.zeebe.gateway.impl.configuration.IdentityServiceCfg;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class IdentityTenantService {
    private static final TimeUnit TIME_UNIT = TimeUnit.MILLISECONDS;
    private final LoadingCache<String, List<Tenant>> tenantCache;
    private final Semaphore semaphore;
    private final Identity identity;
    private final boolean isCachingEnabled;
    private final long tenantRequestTimeout;

    public IdentityTenantService(Identity identity, IdentityServiceCfg config) {
        this.identity = identity;
        this.isCachingEnabled = config.isEnabled();
        this.tenantRequestTimeout = config.getTenantRequestTimeout();
        this.semaphore = new Semaphore(config.getTenantRequestCapacity());
        this.tenantCache = CacheBuilder.newBuilder().expireAfterWrite(config.getTenantCacheTtl(), TIME_UNIT).maximumSize(config.getTenantCacheSize()).build((CacheLoader)new CacheLoader<String, List<Tenant>>(){

            public List<Tenant> load(String token) {
                return IdentityTenantService.this.getTenantsForTokenThrottled(token);
            }
        });
    }

    public List<Tenant> getTenantsForToken(String token) throws ExecutionException {
        if (!this.isCachingEnabled) {
            return this.getTenantsForTokenInternal(token);
        }
        return (List)this.tenantCache.get((Object)token);
    }

    private List<Tenant> getTenantsForTokenThrottled(String token) {
        try {
            if (!this.semaphore.tryAcquire(this.tenantRequestTimeout, TIME_UNIT)) {
                throw new ConcurrentRequestException(this.tenantRequestTimeout, TIME_UNIT);
            }
            List<Tenant> list = this.getTenantsForTokenInternal(token);
            return list;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Expected to fetch tenants from Identity, but the request was interrupted", e);
        }
        finally {
            this.semaphore.release();
        }
    }

    private List<Tenant> getTenantsForTokenInternal(String token) {
        return this.identity.tenants().forToken(token);
    }
}

