/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl;

import io.camunda.zeebe.broker.client.api.BrokerClusterState;
import io.camunda.zeebe.gateway.health.Status;
import io.camunda.zeebe.gateway.impl.stream.JobStreamClient;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.stereotype.Component;

@Component
public class SpringGatewayBridge {
    private Supplier<Status> gatewayStatusSupplier;
    private Supplier<Optional<BrokerClusterState>> clusterStateSupplier;
    private Supplier<JobStreamClient> jobStreamClientSupplier;

    public void registerGatewayStatusSupplier(Supplier<Status> gatewayStatusSupplier) {
        this.gatewayStatusSupplier = gatewayStatusSupplier;
    }

    public void registerClusterStateSupplier(Supplier<Optional<BrokerClusterState>> clusterStateSupplier) {
        this.clusterStateSupplier = clusterStateSupplier;
    }

    public Optional<Status> getGatewayStatus() {
        return Optional.ofNullable(this.gatewayStatusSupplier).map(Supplier::get);
    }

    public Optional<BrokerClusterState> getClusterState() {
        return Optional.ofNullable(this.clusterStateSupplier).flatMap(Supplier::get);
    }

    public Optional<JobStreamClient> getJobStreamClient() {
        return Optional.ofNullable(this.jobStreamClientSupplier).map(Supplier::get);
    }

    public void registerJobStreamClient(Supplier<JobStreamClient> jobStreamClientSupplier) {
        this.jobStreamClientSupplier = jobStreamClientSupplier;
    }
}

