/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.grpc;

import com.fasterxml.jackson.core.JsonParseException;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import io.atomix.cluster.messaging.MessagingException;
import io.camunda.zeebe.broker.client.api.BrokerErrorException;
import io.camunda.zeebe.broker.client.api.BrokerRejectionException;
import io.camunda.zeebe.broker.client.api.NoTopologyAvailableException;
import io.camunda.zeebe.broker.client.api.PartitionNotFoundException;
import io.camunda.zeebe.broker.client.api.RequestRetriesExhaustedException;
import io.camunda.zeebe.broker.client.api.dto.BrokerError;
import io.camunda.zeebe.broker.client.api.dto.BrokerRejection;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.cmd.IllegalTenantRequestException;
import io.camunda.zeebe.gateway.cmd.InvalidBrokerRequestArgumentException;
import io.camunda.zeebe.gateway.cmd.InvalidTenantRequestException;
import io.camunda.zeebe.msgpack.MsgpackPropertyException;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import io.netty.channel.ConnectTimeoutException;
import java.lang.runtime.SwitchBootstraps;
import java.net.ConnectException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public final class GrpcErrorMapper {
    public StatusRuntimeException mapError(Throwable error) {
        return this.mapError(error, Loggers.GATEWAY_LOGGER);
    }

    StatusRuntimeException mapError(Throwable error, Logger logger) {
        return StatusProto.toStatusRuntimeException((Status)this.mapErrorToStatus(error, logger));
    }

    private Status mapErrorToStatus(Throwable error, Logger logger) {
        return this.mapErrorToStatus(error, error, logger);
    }

    private Status mapErrorToStatus(Throwable rootError, Throwable error, Logger logger) {
        Status.Builder builder = Status.newBuilder();
        Throwable throwable = error;
        Objects.requireNonNull(throwable);
        Throwable throwable2 = throwable;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ExecutionException.class, BrokerErrorException.class, BrokerRejectionException.class, TimeoutException.class, InvalidBrokerRequestArgumentException.class, MsgpackPropertyException.class, JsonParseException.class, InvalidTenantRequestException.class, IllegalTenantRequestException.class, IllegalArgumentException.class, PartitionNotFoundException.class, RequestRetriesExhaustedException.class, NoTopologyAvailableException.class, ConnectTimeoutException.class, ConnectException.class, MessagingException.ConnectionClosed.class}, (Object)throwable2, n)) {
            case 0: {
                ExecutionException e = (ExecutionException)throwable2;
                return this.mapErrorToStatus(rootError, e.getCause(), logger);
            }
            case 1: {
                BrokerErrorException brokerError = (BrokerErrorException)throwable2;
                Status status = this.mapBrokerErrorToStatus(rootError, brokerError.getError(), logger);
                builder.mergeFrom(status);
                break;
            }
            case 2: {
                BrokerRejectionException rejection = (BrokerRejectionException)throwable2;
                Status status = this.mapRejectionToStatus(rejection.getRejection());
                builder.mergeFrom(status);
                logger.trace("Expected to handle gRPC request, but the broker rejected it", rootError);
                break;
            }
            case 3: {
                TimeoutException ignored = (TimeoutException)throwable2;
                builder.setCode(4).setMessage("Time out between gateway and broker: " + error.getMessage());
                logger.debug("Expected to handle gRPC request, but request timed out between gateway and broker", rootError);
                break;
            }
            case 4: {
                InvalidBrokerRequestArgumentException ignored = (InvalidBrokerRequestArgumentException)throwable2;
                builder.setCode(3).setMessage(error.getMessage());
                logger.debug("Expected to handle gRPC request, but broker argument was invalid", rootError);
                break;
            }
            case 5: {
                MsgpackPropertyException ignored = (MsgpackPropertyException)throwable2;
                builder.setCode(3).setMessage(error.getMessage());
                logger.debug("Expected to handle gRPC request, but messagepack property was invalid", rootError);
                break;
            }
            case 6: {
                JsonParseException ignored = (JsonParseException)throwable2;
                builder.setCode(3).setMessage(error.getMessage());
                logger.debug("Expected to handle gRPC request, but JSON property was invalid", rootError);
                break;
            }
            case 7: {
                InvalidTenantRequestException ignored = (InvalidTenantRequestException)throwable2;
                builder.setCode(3).setMessage(error.getMessage());
                logger.debug(error.getMessage(), rootError);
                break;
            }
            case 8: {
                IllegalTenantRequestException ignored = (IllegalTenantRequestException)throwable2;
                builder.setCode(7).setMessage(error.getMessage());
                logger.debug(error.getMessage(), rootError);
                break;
            }
            case 9: {
                IllegalArgumentException ignored = (IllegalArgumentException)throwable2;
                builder.setCode(3).setMessage(error.getMessage());
                logger.debug("Expected to handle gRPC request, but JSON property was invalid", rootError);
                break;
            }
            case 10: {
                PartitionNotFoundException ignored = (PartitionNotFoundException)throwable2;
                builder.setCode(14).setMessage(error.getMessage());
                logger.debug("Expected to handle gRPC request, but request could not be delivered", rootError);
                break;
            }
            case 11: {
                RequestRetriesExhaustedException ignored = (RequestRetriesExhaustedException)throwable2;
                builder.setCode(8).setMessage(error.getMessage());
                for (Throwable suppressed : error.getSuppressed()) {
                    builder.addDetails(Any.pack((Message)this.mapErrorToStatus(rootError, suppressed, (Logger)NOPLogger.NOP_LOGGER)));
                }
                logger.trace("Expected to handle gRPC request, but all retries have been exhausted", rootError);
                break;
            }
            case 12: {
                NoTopologyAvailableException ignored = (NoTopologyAvailableException)throwable2;
                builder.setCode(14).setMessage(error.getMessage());
                logger.trace("Expected to handle gRPC request, but the gateway does not know any partitions yet", rootError);
                break;
            }
            case 13: {
                ConnectTimeoutException ignored = (ConnectTimeoutException)throwable2;
                builder.setCode(14).setMessage(error.getMessage());
                logger.warn("Expected to handle gRPC request, but a connection timeout exception occurred", rootError);
                break;
            }
            case 14: {
                ConnectException ignored = (ConnectException)throwable2;
                builder.setCode(14).setMessage(error.getMessage());
                logger.warn("Expected to handle gRPC request, but there was a connection error with one of the brokers", rootError);
                break;
            }
            case 15: {
                MessagingException.ConnectionClosed ignored = (MessagingException.ConnectionClosed)throwable2;
                builder.setCode(10).setMessage(error.getMessage());
                logger.warn("Expected to handle gRPC request, but the connection was cut prematurely with the broker; the request may or may not have been accepted, and may not be safe to retry.", rootError);
                break;
            }
            default: {
                builder.setCode(13).setMessage("Unexpected error occurred during the request processing: " + error.getMessage());
                logger.error("Expected to handle gRPC request, but an unexpected error occurred", rootError);
            }
        }
        return builder.build();
    }

    private Status mapBrokerErrorToStatus(Throwable rootError, BrokerError error, Logger logger) {
        Status.Builder builder = Status.newBuilder();
        String message = error.getMessage();
        switch (error.getCode()) {
            case PROCESS_NOT_FOUND: {
                builder.setCode(5);
                break;
            }
            case RESOURCE_EXHAUSTED: {
                builder.setCode(8);
                logger.trace("Target broker is currently overloaded: {}", (Object)error, (Object)rootError);
                break;
            }
            case PARTITION_LEADER_MISMATCH: {
                logger.trace("Target broker was not the leader of the partition: {}", (Object)error, (Object)rootError);
                builder.setCode(14);
                break;
            }
            case MALFORMED_REQUEST: {
                builder.setCode(3);
                break;
            }
            default: {
                logger.error("Expected to handle gRPC request, but received an internal error from broker: {}", (Object)error, (Object)rootError);
                builder.setCode(13);
                message = String.format("Unexpected error occurred between gateway and broker (code: %s) (message: %s)", error.getCode(), error.getMessage());
            }
        }
        return builder.setMessage(message).build();
    }

    private Status mapRejectionToStatus(BrokerRejection rejection) {
        String message = String.format("Command '%s' rejected with code '%s': %s", rejection.intent(), rejection.type(), rejection.reason());
        Status.Builder builder = Status.newBuilder().setMessage(message);
        switch (rejection.type()) {
            case INVALID_ARGUMENT: {
                builder.setCode(3);
                break;
            }
            case NOT_FOUND: {
                builder.setCode(5);
                break;
            }
            case ALREADY_EXISTS: {
                builder.setCode(6);
                break;
            }
            case INVALID_STATE: {
                builder.setCode(9);
                break;
            }
            case PROCESSING_ERROR: {
                builder.setCode(13);
                break;
            }
            default: {
                builder.setCode(2);
            }
        }
        return builder.build();
    }
}

