/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.admin.backup;

import io.camunda.zeebe.broker.client.api.dto.BrokerRequest;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.protocol.impl.encoding.BackupListResponse;
import io.camunda.zeebe.protocol.impl.encoding.BackupRequest;
import io.camunda.zeebe.protocol.management.BackupRequestType;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class BackupListRequest
extends BrokerRequest<BackupListResponse> {
    protected final BackupRequest request = new BackupRequest();
    protected final BackupListResponse response = new BackupListResponse();

    public BackupListRequest() {
        super(1, 5);
        this.request.setType(BackupRequestType.LIST);
    }

    public long getBackupId() {
        return this.request.getBackupId();
    }

    public void setBackupId(long backupId) {
        this.request.setBackupId(backupId);
    }

    public int getPartitionId() {
        return this.request.getPartitionId();
    }

    public void setPartitionId(int partitionId) {
        this.request.setPartitionId(partitionId);
    }

    public boolean addressesSpecificPartition() {
        return true;
    }

    public boolean requiresPartitionId() {
        return true;
    }

    public BufferWriter getRequestWriter() {
        return null;
    }

    protected void setSerializedValue(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    protected void wrapResponse(DirectBuffer buffer) {
        this.response.wrap(buffer, 0, buffer.capacity());
    }

    protected BrokerResponse<BackupListResponse> readResponse() {
        return new BrokerResponse((Object)this.response, this.getPartitionId(), -1L);
    }

    protected BackupListResponse toResponseDto(DirectBuffer buffer) {
        return this.response;
    }

    public String getType() {
        return "Backup#list";
    }

    public RequestType getRequestType() {
        return RequestType.BACKUP;
    }

    public int getLength() {
        return this.request.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.request.write(buffer, offset);
    }
}

