/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.admin;

import io.camunda.zeebe.broker.client.api.dto.BrokerRequest;
import io.camunda.zeebe.broker.client.api.dto.BrokerResponse;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.encoding.AdminRequest;
import io.camunda.zeebe.protocol.impl.encoding.AdminResponse;
import io.camunda.zeebe.protocol.management.AdminRequestEncoder;
import io.camunda.zeebe.protocol.management.AdminRequestType;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class BrokerAdminRequest
extends BrokerRequest<Void> {
    private final AdminRequest request = new AdminRequest();
    private final AdminResponse response = new AdminResponse();

    public BrokerAdminRequest() {
        super(1, 2);
    }

    public void stepDownIfNotPrimary() {
        this.request.setType(AdminRequestType.STEP_DOWN_IF_NOT_PRIMARY);
    }

    public void pauseExporting() {
        this.request.setType(AdminRequestType.PAUSE_EXPORTING);
    }

    public void softPauseExporting() {
        this.request.setType(AdminRequestType.SOFT_PAUSE_EXPORTING);
    }

    public void resumeExporting() {
        this.request.setType(AdminRequestType.RESUME_EXPORTING);
    }

    public BrokerAdminRequest banInstance(long key) {
        this.request.setType(AdminRequestType.BAN_INSTANCE);
        this.request.setKey(key);
        this.request.setPartitionId(Protocol.decodePartitionId((long)key));
        return this;
    }

    public Optional<Integer> getBrokerId() {
        int brokerId = this.request.getBrokerId();
        if (brokerId != AdminRequestEncoder.brokerIdNullValue()) {
            return Optional.of(brokerId);
        }
        return Optional.empty();
    }

    public void setBrokerId(int brokerId) {
        this.request.setBrokerId(brokerId);
    }

    public int getPartitionId() {
        return this.request.getPartitionId();
    }

    public void setPartitionId(int partitionId) {
        this.request.setPartitionId(partitionId);
    }

    public boolean addressesSpecificPartition() {
        return true;
    }

    public boolean requiresPartitionId() {
        return true;
    }

    public BufferWriter getRequestWriter() {
        return null;
    }

    protected void setSerializedValue(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    protected void wrapResponse(DirectBuffer buffer) {
        this.response.wrap(buffer, 0, buffer.capacity());
    }

    protected BrokerResponse<Void> readResponse() {
        return new BrokerResponse(null);
    }

    protected Void toResponseDto(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public String getType() {
        return "Admin#" + String.valueOf(this.request.getType());
    }

    public RequestType getRequestType() {
        return RequestType.ADMIN;
    }

    public int getLength() {
        return this.request.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.request.write(buffer, offset);
    }
}

