/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway;

import com.fasterxml.jackson.core.JsonParseException;
import io.camunda.zeebe.gateway.cmd.IllegalTenantRequestException;
import io.camunda.zeebe.gateway.cmd.InvalidTenantRequestException;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerActivateJobsRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerBroadcastSignalRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerCancelProcessInstanceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerCompleteJobRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerCreateProcessInstanceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerCreateProcessInstanceWithResultRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerDeleteResourceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerDeployResourceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerEvaluateDecisionRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerFailJobRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerMigrateProcessInstanceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerModifyProcessInstanceRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerPublishMessageRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerResolveIncidentRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerSetVariablesRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerThrowErrorRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerUpdateJobRetriesRequest;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerUpdateJobTimeoutRequest;
import io.camunda.zeebe.gateway.interceptors.InterceptorUtil;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationPropertiesImpl;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.grpc.Context;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.apache.commons.lang3.StringUtils;

public final class RequestMapper {
    private static final Pattern TENANT_ID_MASK = Pattern.compile("^[\\w\\.-]{1,31}$");
    private static boolean isMultiTenancyEnabled = false;

    public static void setMultiTenancyEnabled(boolean isEnabled) {
        isMultiTenancyEnabled = isEnabled;
    }

    public static BrokerDeployResourceRequest toDeployProcessRequest(GatewayOuterClass.DeployProcessRequest grpcRequest) {
        RequestMapper.ensureTenantIdSet("DeployProcess", "<default>");
        BrokerDeployResourceRequest brokerRequest = new BrokerDeployResourceRequest();
        for (GatewayOuterClass.ProcessRequestObject process : grpcRequest.getProcessesList()) {
            brokerRequest.addResource(process.getDefinition().toByteArray(), process.getName());
        }
        brokerRequest.setTenantId("<default>");
        return brokerRequest;
    }

    public static BrokerDeployResourceRequest toDeployResourceRequest(GatewayOuterClass.DeployResourceRequest grpcRequest) {
        BrokerDeployResourceRequest brokerRequest = new BrokerDeployResourceRequest();
        String tenantId = grpcRequest.getTenantId();
        brokerRequest.setTenantId(RequestMapper.ensureTenantIdSet("DeployResource", tenantId));
        for (GatewayOuterClass.Resource resource : grpcRequest.getResourcesList()) {
            brokerRequest.addResource(resource.getContent().toByteArray(), resource.getName());
        }
        return brokerRequest;
    }

    public static BrokerPublishMessageRequest toPublishMessageRequest(GatewayOuterClass.PublishMessageRequest grpcRequest) {
        BrokerPublishMessageRequest brokerRequest = new BrokerPublishMessageRequest(grpcRequest.getName(), grpcRequest.getCorrelationKey());
        brokerRequest.setMessageId(grpcRequest.getMessageId()).setTimeToLive(grpcRequest.getTimeToLive()).setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables())).setTenantId(RequestMapper.ensureTenantIdSet("PublishMessage", grpcRequest.getTenantId()));
        return brokerRequest;
    }

    public static BrokerUpdateJobRetriesRequest toUpdateJobRetriesRequest(GatewayOuterClass.UpdateJobRetriesRequest grpcRequest) {
        return new BrokerUpdateJobRetriesRequest(grpcRequest.getJobKey(), grpcRequest.getRetries());
    }

    public static BrokerUpdateJobTimeoutRequest toUpdateJobTimeoutRequest(GatewayOuterClass.UpdateJobTimeoutRequest grpcRequest) {
        return new BrokerUpdateJobTimeoutRequest(grpcRequest.getJobKey(), grpcRequest.getTimeout());
    }

    public static BrokerFailJobRequest toFailJobRequest(GatewayOuterClass.FailJobRequest grpcRequest) {
        return new BrokerFailJobRequest(grpcRequest.getJobKey(), grpcRequest.getRetries(), grpcRequest.getRetryBackOff()).setErrorMessage(grpcRequest.getErrorMessage()).setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables()));
    }

    public static BrokerThrowErrorRequest toThrowErrorRequest(GatewayOuterClass.ThrowErrorRequest grpcRequest) {
        return new BrokerThrowErrorRequest(grpcRequest.getJobKey(), grpcRequest.getErrorCode()).setErrorMessage(grpcRequest.getErrorMessage()).setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables()));
    }

    public static BrokerCompleteJobRequest toCompleteJobRequest(GatewayOuterClass.CompleteJobRequest grpcRequest) {
        return new BrokerCompleteJobRequest(grpcRequest.getJobKey(), RequestMapper.ensureJsonSet(grpcRequest.getVariables()));
    }

    public static BrokerCreateProcessInstanceRequest toCreateProcessInstanceRequest(GatewayOuterClass.CreateProcessInstanceRequest grpcRequest) {
        BrokerCreateProcessInstanceRequest brokerRequest = new BrokerCreateProcessInstanceRequest();
        brokerRequest.setBpmnProcessId(grpcRequest.getBpmnProcessId()).setKey(grpcRequest.getProcessDefinitionKey()).setVersion(grpcRequest.getVersion()).setTenantId(RequestMapper.ensureTenantIdSet("CreateProcessInstance", grpcRequest.getTenantId())).setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables())).setStartInstructions(grpcRequest.getStartInstructionsList());
        return brokerRequest;
    }

    public static BrokerCreateProcessInstanceWithResultRequest toCreateProcessInstanceWithResultRequest(GatewayOuterClass.CreateProcessInstanceWithResultRequest grpcRequest) {
        BrokerCreateProcessInstanceWithResultRequest brokerRequest = new BrokerCreateProcessInstanceWithResultRequest();
        GatewayOuterClass.CreateProcessInstanceRequest request = grpcRequest.getRequest();
        brokerRequest.setBpmnProcessId(request.getBpmnProcessId()).setKey(request.getProcessDefinitionKey()).setVersion(request.getVersion()).setTenantId(RequestMapper.ensureTenantIdSet("CreateProcessInstanceWithResult", request.getTenantId())).setVariables(RequestMapper.ensureJsonSet(request.getVariables())).setStartInstructions(request.getStartInstructionsList()).setFetchVariables((List<String>)grpcRequest.getFetchVariablesList());
        return brokerRequest;
    }

    public static BrokerEvaluateDecisionRequest toEvaluateDecisionRequest(GatewayOuterClass.EvaluateDecisionRequest grpcRequest) {
        BrokerEvaluateDecisionRequest brokerRequest = new BrokerEvaluateDecisionRequest();
        brokerRequest.setDecisionId(grpcRequest.getDecisionId()).setDecisionKey(grpcRequest.getDecisionKey()).setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables())).setTenantId(RequestMapper.ensureTenantIdSet("EvaluateDecision", grpcRequest.getTenantId()));
        return brokerRequest;
    }

    public static BrokerCancelProcessInstanceRequest toCancelProcessInstanceRequest(GatewayOuterClass.CancelProcessInstanceRequest grpcRequest) {
        BrokerCancelProcessInstanceRequest brokerRequest = new BrokerCancelProcessInstanceRequest();
        brokerRequest.setProcessInstanceKey(grpcRequest.getProcessInstanceKey());
        return brokerRequest;
    }

    public static BrokerSetVariablesRequest toSetVariablesRequest(GatewayOuterClass.SetVariablesRequest grpcRequest) {
        BrokerSetVariablesRequest brokerRequest = new BrokerSetVariablesRequest();
        brokerRequest.setElementInstanceKey(grpcRequest.getElementInstanceKey());
        brokerRequest.setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables()));
        brokerRequest.setLocal(grpcRequest.getLocal());
        return brokerRequest;
    }

    public static BrokerActivateJobsRequest toActivateJobsRequest(GatewayOuterClass.ActivateJobsRequest grpcRequest) {
        Object tenantIds = grpcRequest.getTenantIdsList();
        tenantIds = RequestMapper.ensureTenantIdsSet("ActivateJobs", (List<String>)tenantIds);
        return new BrokerActivateJobsRequest(grpcRequest.getType()).setTimeout(grpcRequest.getTimeout()).setWorker(grpcRequest.getWorker()).setMaxJobsToActivate(grpcRequest.getMaxJobsToActivate()).setVariables((List<String>)grpcRequest.getFetchVariableList()).setTenantIds((List<String>)tenantIds);
    }

    public static BrokerResolveIncidentRequest toResolveIncidentRequest(GatewayOuterClass.ResolveIncidentRequest grpcRequest) {
        return new BrokerResolveIncidentRequest(grpcRequest.getIncidentKey());
    }

    public static BrokerModifyProcessInstanceRequest toModifyProcessInstanceRequest(GatewayOuterClass.ModifyProcessInstanceRequest grpcRequest) {
        return new BrokerModifyProcessInstanceRequest().setProcessInstanceKey(grpcRequest.getProcessInstanceKey()).addActivateInstructions(grpcRequest.getActivateInstructionsList()).addTerminateInstructions(grpcRequest.getTerminateInstructionsList());
    }

    public static BrokerMigrateProcessInstanceRequest toMigrateProcessInstanceRequest(GatewayOuterClass.MigrateProcessInstanceRequest grpcRequest) {
        return new BrokerMigrateProcessInstanceRequest().setProcessInstanceKey(grpcRequest.getProcessInstanceKey()).setTargetProcessDefinitionKey(grpcRequest.getMigrationPlan().getTargetProcessDefinitionKey()).addMappingInstructions(grpcRequest.getMigrationPlan().getMappingInstructionsList());
    }

    public static BrokerDeleteResourceRequest toDeleteResourceRequest(GatewayOuterClass.DeleteResourceRequest grpcRequest) {
        return new BrokerDeleteResourceRequest().setResourceKey(grpcRequest.getResourceKey());
    }

    public static BrokerBroadcastSignalRequest toBroadcastSignalRequest(GatewayOuterClass.BroadcastSignalRequest grpcRequest) {
        return new BrokerBroadcastSignalRequest(grpcRequest.getSignalName()).setVariables(RequestMapper.ensureJsonSet(grpcRequest.getVariables())).setTenantId(RequestMapper.ensureTenantIdSet("BroadcastSignal", grpcRequest.getTenantId()));
    }

    public static JobActivationProperties toJobActivationProperties(GatewayOuterClass.StreamActivatedJobsRequest request) {
        Object tenantIds = request.getTenantIdsList();
        tenantIds = RequestMapper.ensureTenantIdsSet("StreamActivatedJobs", (List<String>)tenantIds);
        JobActivationPropertiesImpl jobActivationProperties = new JobActivationPropertiesImpl();
        DirectBuffer worker = BufferUtil.wrapString((String)request.getWorker());
        jobActivationProperties.setWorker(worker, 0, worker.capacity()).setTimeout(request.getTimeout()).setFetchVariables(request.getFetchVariableList().stream().map(StringValue::new).toList()).setTenantIds((Collection)tenantIds);
        return jobActivationProperties;
    }

    public static DirectBuffer ensureJsonSet(String value) {
        if (value == null || value.trim().isEmpty()) {
            return DocumentValue.EMPTY_DOCUMENT;
        }
        try {
            return new UnsafeBuffer(MsgPackConverter.convertToMsgPack((String)value));
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof JsonParseException) {
                JsonParseException parseException = (JsonParseException)cause;
                JsonParseException descriptiveException = new JsonParseException(parseException.getProcessor(), "Invalid JSON value: " + value, parseException.getLocation(), cause);
                LangUtil.rethrowUnchecked((Throwable)descriptiveException);
                return DocumentValue.EMPTY_DOCUMENT;
            }
            if (cause instanceof IllegalArgumentException) {
                LangUtil.rethrowUnchecked((Throwable)cause);
                return DocumentValue.EMPTY_DOCUMENT;
            }
            throw e;
        }
    }

    public static String ensureTenantIdSet(String commandName, String tenantId) {
        List authorizedTenants;
        boolean hasTenantId;
        boolean bl = hasTenantId = !StringUtils.isBlank((CharSequence)tenantId);
        if (!isMultiTenancyEnabled) {
            if (hasTenantId && !"<default>".equals(tenantId)) {
                throw new InvalidTenantRequestException(commandName, tenantId, "multi-tenancy is disabled");
            }
            return "<default>";
        }
        if (!hasTenantId) {
            throw new InvalidTenantRequestException(commandName, tenantId, "no tenant identifier was provided.");
        }
        if (tenantId.length() > 31) {
            throw new InvalidTenantRequestException(commandName, tenantId, "tenant identifier is longer than 31 characters");
        }
        if (!"<default>".equals(tenantId) && !TENANT_ID_MASK.matcher(tenantId).matches()) {
            throw new InvalidTenantRequestException(commandName, tenantId, "tenant identifier contains illegal characters");
        }
        try {
            authorizedTenants = (List)Context.current().call(() -> InterceptorUtil.getAuthorizedTenantsKey().get());
        }
        catch (Exception e) {
            throw new InvalidTenantRequestException(commandName, tenantId, "tenant could not be retrieved from the request context", e);
        }
        if (authorizedTenants == null) {
            throw new InvalidTenantRequestException(commandName, tenantId, "tenant could not be retrieved from the request context");
        }
        if (!authorizedTenants.contains(tenantId)) {
            throw new IllegalTenantRequestException(commandName, tenantId, "tenant is not authorized to perform this request");
        }
        return tenantId;
    }

    public static List<String> ensureTenantIdsSet(String commandName, List<String> tenantIds) {
        if (tenantIds.isEmpty()) {
            if (!isMultiTenancyEnabled) {
                return List.of("<default>");
            }
            throw new InvalidTenantRequestException(commandName, tenantIds, "no tenant identifiers were provided.");
        }
        tenantIds.stream().forEach(tenantId -> RequestMapper.ensureTenantIdSet(commandName, tenantId));
        return tenantIds;
    }
}

