/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.feel.tagged.impl;

import io.camunda.zeebe.feel.tagged.impl.FromAiTaggedParameterExtractor;
import io.camunda.zeebe.feel.tagged.impl.FunctionInvocationTaggedParameterExtractor;
import io.camunda.zeebe.feel.tagged.impl.TaggedParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.camunda.feel.syntaxtree.FunctionInvocation;
import org.camunda.feel.syntaxtree.ParsedExpression;
import scala.Product;
import scala.collection.Iterator;
import scala.jdk.javaapi.CollectionConverters;

public class TaggedParameterExtractor {
    private final Map<String, FunctionInvocationTaggedParameterExtractor> extractorsByFunctionName = new LinkedHashMap<String, FunctionInvocationTaggedParameterExtractor>();

    public TaggedParameterExtractor() {
        this(List.of(new FromAiTaggedParameterExtractor()));
    }

    public TaggedParameterExtractor(List<FunctionInvocationTaggedParameterExtractor> extractorsByFunctionName) {
        Objects.requireNonNull(extractorsByFunctionName, "Parameter extractors must not be null");
        extractorsByFunctionName.forEach(extractor -> this.extractorsByFunctionName.put(extractor.functionName(), (FunctionInvocationTaggedParameterExtractor)extractor));
    }

    public List<TaggedParameter> extractParameters(ParsedExpression parsedExpression) {
        List<TaggedParameter> extracted = this.extractParameters(parsedExpression.expression(), new ArrayList<TaggedParameter>());
        return Collections.unmodifiableList(extracted);
    }

    private List<TaggedParameter> extractParameters(Object object, List<TaggedParameter> extracted) {
        if (this.isSupportedFunctionInvocation(object)) {
            this.processFunctionInvocation((FunctionInvocation)object, extracted);
            return extracted;
        }
        if (!(object instanceof Product)) {
            return extracted;
        }
        Product product = (Product)object;
        CollectionConverters.asJava((Iterator)product.productIterator()).forEachRemaining(obj -> {
            if (this.isSupportedFunctionInvocation(obj)) {
                this.processFunctionInvocation((FunctionInvocation)obj, extracted);
            } else {
                this.extractParameters(obj, extracted);
            }
        });
        return extracted;
    }

    private boolean isSupportedFunctionInvocation(Object object) {
        FunctionInvocation functionInvocation;
        return object instanceof FunctionInvocation && this.extractorsByFunctionName.containsKey((functionInvocation = (FunctionInvocation)object).function());
    }

    private void processFunctionInvocation(FunctionInvocation functionInvocation, List<TaggedParameter> extracted) {
        extracted.add(this.extractorsByFunctionName.get(functionInvocation.function()).extract(functionInvocation));
    }
}

