/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.exporter.ElasticsearchExporter;
import io.camunda.zeebe.exporter.ElasticsearchExporterConfiguration;
import io.camunda.zeebe.exporter.ElasticsearchExporterException;
import io.camunda.zeebe.exporter.dto.Template;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.VersionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;

final class TemplateReader {
    private static final String INDEX_TEMPLATE_FILENAME_PATTERN = "/zeebe-record-%s-template.json";
    private static final String ZEEBE_RECORD_TEMPLATE_JSON = "/zeebe-record-template.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final ElasticsearchExporterConfiguration config;

    public TemplateReader(ElasticsearchExporterConfiguration config) {
        this.config = config;
    }

    Template readComponentTemplate() {
        return this.readTemplate(ZEEBE_RECORD_TEMPLATE_JSON);
    }

    Template readIndexTemplate(ValueType valueType, String searchPattern, String aliasName) {
        Template template = this.readTemplate(this.findResourceForTemplate(valueType));
        return Template.MutableCopyBuilder.copyOf(template).updateComposedOf(composedOf -> composedOf.set(0, this.config.index.prefix + "-" + VersionUtil.getVersionLowerCase())).updatePatterns(patterns -> patterns.set(0, searchPattern)).updateAliases(aliases -> {
            aliases.clear();
            aliases.put(aliasName, Collections.emptyMap());
        }).withPriority(Long.valueOf(this.config.index.getTemplatePriority())).build();
    }

    private String findResourceForTemplate(ValueType valueType) {
        return String.format(INDEX_TEMPLATE_FILENAME_PATTERN, this.valueTypeToString(valueType));
    }

    private String valueTypeToString(ValueType valueType) {
        return valueType.name().toLowerCase().replace("_", "-");
    }

    private Template readTemplate(String resourcePath) {
        Template template = this.getTemplateFromClasspath(resourcePath);
        Map<String, Object> settings = template.template().settings();
        this.substituteConfiguration(settings);
        return template;
    }

    private void substituteConfiguration(Map<String, Object> settings) {
        Integer numberOfReplicas;
        Integer numberOfShards = this.config.index.getNumberOfShards();
        if (numberOfShards != null) {
            settings.put("number_of_shards", numberOfShards);
        }
        if ((numberOfReplicas = this.config.index.getNumberOfReplicas()) != null) {
            settings.put("number_of_replicas", numberOfReplicas);
        }
        if (this.config.retention.isEnabled()) {
            settings.put("index.lifecycle.name", this.config.retention.getPolicyName());
        }
    }

    private Template getTemplateFromClasspath(String filename) {
        Template template;
        block8: {
            InputStream inputStream = ElasticsearchExporter.class.getResourceAsStream(filename);
            try {
                template = (Template)MAPPER.readValue(inputStream, Template.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ElasticsearchExporterException("Failed to load index template from classpath " + filename, e);
                }
            }
            inputStream.close();
        }
        return template;
    }
}

