/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import io.camunda.search.connect.plugin.PluginConfiguration;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import java.util.ArrayList;
import java.util.List;

public class ElasticsearchExporterConfiguration {
    private static final String DEFAULT_URL = "http://localhost:9200";
    public String url = "http://localhost:9200";
    public int requestTimeoutMs = 30000;
    public final IndexConfiguration index = new IndexConfiguration();
    public final BulkConfiguration bulk = new BulkConfiguration();
    public final RetentionConfiguration retention = new RetentionConfiguration();
    public final List<PluginConfiguration> interceptorPlugins = new ArrayList<PluginConfiguration>();
    private final AuthenticationConfiguration authentication = new AuthenticationConfiguration();
    private boolean includeEnabledRecords = false;

    public boolean hasAuthenticationPresent() {
        return this.getAuthentication().isPresent();
    }

    public AuthenticationConfiguration getAuthentication() {
        return this.authentication;
    }

    public List<PluginConfiguration> getInterceptorPlugins() {
        return this.interceptorPlugins;
    }

    public String toString() {
        return "ElasticsearchExporterConfiguration{url='" + this.url + "', requestTimeoutMs=" + this.requestTimeoutMs + ", index=" + String.valueOf(this.index) + ", bulk=" + String.valueOf(this.bulk) + ", retention=" + String.valueOf(this.retention) + ", authentication=" + String.valueOf(this.authentication) + ", interceptors=" + String.valueOf(this.interceptorPlugins) + "}";
    }

    public boolean shouldIndexRecord(Record<?> record) {
        return this.shouldIndexRecordType(record.getRecordType()) && this.shouldIndexValueType(record.getValueType());
    }

    public boolean shouldIndexValueType(ValueType valueType) {
        return switch (valueType) {
            case ValueType.DEPLOYMENT -> this.index.deployment;
            case ValueType.PROCESS -> this.index.process;
            case ValueType.ERROR -> this.index.error;
            case ValueType.INCIDENT -> this.index.incident;
            case ValueType.JOB -> this.index.job;
            case ValueType.JOB_BATCH -> this.index.jobBatch;
            case ValueType.MESSAGE -> this.index.message;
            case ValueType.MESSAGE_BATCH -> this.index.messageBatch;
            case ValueType.MESSAGE_SUBSCRIPTION -> this.index.messageSubscription;
            case ValueType.VARIABLE -> this.index.variable;
            case ValueType.VARIABLE_DOCUMENT -> this.index.variableDocument;
            case ValueType.PROCESS_INSTANCE -> this.index.processInstance;
            case ValueType.PROCESS_INSTANCE_BATCH -> this.index.processInstanceBatch;
            case ValueType.PROCESS_INSTANCE_CREATION -> this.index.processInstanceCreation;
            case ValueType.PROCESS_INSTANCE_MIGRATION -> this.index.processInstanceMigration;
            case ValueType.PROCESS_INSTANCE_MODIFICATION -> this.index.processInstanceModification;
            case ValueType.PROCESS_MESSAGE_SUBSCRIPTION -> this.index.processMessageSubscription;
            case ValueType.DECISION_REQUIREMENTS -> this.index.decisionRequirements;
            case ValueType.DECISION -> this.index.decision;
            case ValueType.DECISION_EVALUATION -> this.index.decisionEvaluation;
            case ValueType.CHECKPOINT -> this.index.checkpoint;
            case ValueType.TIMER -> this.index.timer;
            case ValueType.MESSAGE_START_EVENT_SUBSCRIPTION -> this.index.messageStartEventSubscription;
            case ValueType.PROCESS_EVENT -> this.index.processEvent;
            case ValueType.DEPLOYMENT_DISTRIBUTION -> this.index.deploymentDistribution;
            case ValueType.ESCALATION -> this.index.escalation;
            case ValueType.SIGNAL -> this.index.signal;
            case ValueType.SIGNAL_SUBSCRIPTION -> this.index.signalSubscription;
            case ValueType.RESOURCE_DELETION -> this.index.resourceDeletion;
            case ValueType.COMMAND_DISTRIBUTION -> this.index.commandDistribution;
            case ValueType.FORM -> this.index.form;
            case ValueType.USER_TASK -> this.index.userTask;
            case ValueType.COMPENSATION_SUBSCRIPTION -> this.index.compensationSubscription;
            case ValueType.MESSAGE_CORRELATION -> this.index.messageCorrelation;
            case ValueType.AD_HOC_SUB_PROCESS_INSTRUCTION -> this.index.adHocSubProcessInstruction;
            case ValueType.ASYNC_REQUEST -> this.index.asyncRequest;
            case ValueType.RUNTIME_INSTRUCTION -> this.index.runtimeInstruction;
            default -> false;
        };
    }

    public boolean shouldIndexRequiredValueType(ValueType valueType) {
        return switch (valueType) {
            case ValueType.DEPLOYMENT -> this.index.deployment;
            case ValueType.PROCESS -> this.index.process;
            case ValueType.INCIDENT -> this.index.incident;
            case ValueType.VARIABLE -> this.index.variable;
            case ValueType.PROCESS_INSTANCE -> this.index.processInstance;
            case ValueType.USER_TASK -> this.index.userTask;
            case ValueType.JOB -> this.index.job;
            default -> false;
        };
    }

    public boolean shouldIndexRecordType(RecordType recordType) {
        return switch (recordType) {
            case RecordType.EVENT -> this.index.event;
            case RecordType.COMMAND -> this.index.command;
            case RecordType.COMMAND_REJECTION -> this.index.rejection;
            default -> false;
        };
    }

    public boolean getIsIncludeEnabledRecords() {
        return this.includeEnabledRecords;
    }

    public void setIncludeEnabledRecords(boolean includeEnabledRecords) {
        this.includeEnabledRecords = includeEnabledRecords;
    }

    public static class IndexConfiguration {
        private static final int DEFAULT_INDEX_TEMPLATE_PRIORITY = 20;
        public String prefix = "zeebe-record";
        public String indexSuffixDatePattern = "yyyy-MM-dd";
        public boolean createTemplate = true;
        public boolean command = false;
        public boolean event = true;
        public boolean rejection = false;
        public boolean decision = true;
        public boolean decisionEvaluation = true;
        public boolean decisionRequirements = true;
        public boolean deployment = true;
        public boolean error = true;
        public boolean incident = true;
        public boolean job = true;
        public boolean jobBatch = false;
        public boolean message = true;
        public boolean messageBatch = false;
        public boolean messageSubscription = true;
        public boolean process = true;
        public boolean processInstance = true;
        public boolean processInstanceBatch = false;
        public boolean processInstanceCreation = true;
        public boolean processInstanceMigration = true;
        public boolean processInstanceModification = true;
        public boolean processMessageSubscription = true;
        public boolean variable = true;
        public boolean variableDocument = true;
        public boolean adHocSubProcessInstruction = true;
        public boolean checkpoint = false;
        public boolean timer = true;
        public boolean messageStartEventSubscription = true;
        public boolean processEvent = false;
        public boolean deploymentDistribution = true;
        public boolean escalation = true;
        public boolean signal = true;
        public boolean signalSubscription = true;
        public boolean resourceDeletion = true;
        public boolean commandDistribution = true;
        public boolean form = true;
        public boolean userTask = true;
        public boolean compensationSubscription = true;
        public boolean messageCorrelation = true;
        public boolean user = true;
        public boolean authorization = true;
        public boolean runtimeInstruction = true;
        public boolean batchOperationCreation = false;
        public boolean batchOperationChunk = false;
        public boolean batchOperationExecution = false;
        public boolean batchOperationLifecycleManagement = false;
        public boolean batchOperationPartitionLifecycle = false;
        public boolean batchOperationInitialization = false;
        public boolean asyncRequest = false;
        public boolean usageMetrics = false;
        private Integer numberOfShards = null;
        private Integer numberOfReplicas = null;
        private int templatePriority = 20;

        public Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        public Integer getNumberOfReplicas() {
            return this.numberOfReplicas;
        }

        public void setNumberOfReplicas(Integer numberOfReplicas) {
            this.numberOfReplicas = numberOfReplicas;
        }

        public int getTemplatePriority() {
            return this.templatePriority;
        }

        public void setTemplatePriority(int templatePriority) {
            this.templatePriority = templatePriority;
        }

        public String toString() {
            return "IndexConfiguration{prefix='" + this.prefix + "', createTemplate=" + this.createTemplate + ", command=" + this.command + ", event=" + this.event + ", rejection=" + this.rejection + ", decision=" + this.decision + ", decisionEvaluation=" + this.decisionEvaluation + ", decisionRequirements=" + this.decisionRequirements + ", deployment=" + this.deployment + ", error=" + this.error + ", incident=" + this.incident + ", job=" + this.job + ", jobBatch=" + this.jobBatch + ", message=" + this.message + ", messageBatch=" + this.messageBatch + ", messageSubscription=" + this.messageSubscription + ", process=" + this.process + ", processInstance=" + this.processInstance + ", processInstanceBatch=" + this.processInstanceBatch + ", processInstanceCreation=" + this.processInstanceCreation + ", processInstanceMigration=" + this.processInstanceMigration + ", processInstanceModification=" + this.processInstanceModification + ", processMessageSubscription=" + this.processMessageSubscription + ", variable=" + this.variable + ", variableDocument=" + this.variableDocument + ", checkpoint=" + this.checkpoint + ", timer=" + this.timer + ", messageStartEventSubscription=" + this.messageStartEventSubscription + ", processEvent=" + this.processEvent + ", deploymentDistribution=" + this.deploymentDistribution + ", escalation=" + this.escalation + ", signal=" + this.signal + ", signalSubscription=" + this.signalSubscription + ", resourceDeletion=" + this.resourceDeletion + ", adHocSubProcessInstruction=" + this.adHocSubProcessInstruction + ", commandDistribution=" + this.commandDistribution + ", form=" + this.form + ", userTask=" + this.userTask + ", compensationSubscription=" + this.compensationSubscription + ", messageCorrelation=" + this.messageCorrelation + ", user=" + this.user + ", authorization=" + this.authorization + ", asyncRequest=" + this.asyncRequest + "}";
        }
    }

    public static class BulkConfiguration {
        public int delay = 5;
        public int size = 1000;
        public int memoryLimit = 0xA00000;

        public String toString() {
            return "BulkConfiguration{delay=" + this.delay + ", size=" + this.size + ", memoryLimit=" + this.memoryLimit + "}";
        }
    }

    public static class RetentionConfiguration {
        private boolean enabled = false;
        private String minimumAge = "30d";
        private String policyName = "zeebe-record-retention-policy";

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getMinimumAge() {
            return this.minimumAge;
        }

        public void setMinimumAge(String minimumAge) {
            this.minimumAge = minimumAge;
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public String toString() {
            return "RetentionConfiguration{isEnabled=" + this.enabled + ", minimumAge=" + this.minimumAge + ", policyName='" + this.policyName + "'}";
        }
    }

    public static class AuthenticationConfiguration {
        private String username;
        private String password;

        public boolean isPresent() {
            return this.username != null && !this.username.isEmpty() && this.password != null && !this.password.isEmpty();
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String toString() {
            return "AuthenticationConfiguration{Confidential information}";
        }
    }
}

