/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.exporter.BulkIndexRequest;
import io.camunda.zeebe.exporter.ElasticsearchExporterConfiguration;
import io.camunda.zeebe.exporter.ElasticsearchExporterException;
import io.camunda.zeebe.exporter.ElasticsearchMetrics;
import io.camunda.zeebe.exporter.RecordIndexRouter;
import io.camunda.zeebe.exporter.RecordSequence;
import io.camunda.zeebe.exporter.RestClientFactory;
import io.camunda.zeebe.exporter.TemplateReader;
import io.camunda.zeebe.exporter.dto.BulkIndexAction;
import io.camunda.zeebe.exporter.dto.BulkIndexResponse;
import io.camunda.zeebe.exporter.dto.PutIndexLifecycleManagementPolicyRequest;
import io.camunda.zeebe.exporter.dto.PutIndexLifecycleManagementPolicyResponse;
import io.camunda.zeebe.exporter.dto.PutIndexSettingsRequest;
import io.camunda.zeebe.exporter.dto.PutIndexSettingsResponse;
import io.camunda.zeebe.exporter.dto.PutIndexTemplateResponse;
import io.camunda.zeebe.exporter.dto.Template;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.VersionUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

class ElasticsearchClient
implements AutoCloseable {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final RestClient client;
    private final ElasticsearchExporterConfiguration configuration;
    private final TemplateReader templateReader;
    private final RecordIndexRouter indexRouter;
    private final BulkIndexRequest bulkIndexRequest;
    private final ElasticsearchMetrics metrics;
    private Timer.Sample flushLatencyMeasurement;

    ElasticsearchClient(ElasticsearchExporterConfiguration configuration, MeterRegistry meterRegistry) {
        this(configuration, new BulkIndexRequest(), RestClientFactory.of(configuration, new HttpRequestInterceptor[0]), new RecordIndexRouter(configuration.index), new TemplateReader(configuration), new ElasticsearchMetrics(meterRegistry));
    }

    ElasticsearchClient(ElasticsearchExporterConfiguration configuration, MeterRegistry meterRegistry, RestClient restClient) {
        this(configuration, new BulkIndexRequest(), restClient, new RecordIndexRouter(configuration.index), new TemplateReader(configuration), new ElasticsearchMetrics(meterRegistry));
    }

    ElasticsearchClient(ElasticsearchExporterConfiguration configuration, BulkIndexRequest bulkIndexRequest, RestClient client, RecordIndexRouter indexRouter, TemplateReader templateReader, ElasticsearchMetrics metrics) {
        this.configuration = configuration;
        this.bulkIndexRequest = bulkIndexRequest;
        this.client = client;
        this.indexRouter = indexRouter;
        this.templateReader = templateReader;
        this.metrics = metrics;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public boolean index(Record<?> record, RecordSequence recordSequence) {
        if (this.bulkIndexRequest.isEmpty()) {
            this.flushLatencyMeasurement = this.metrics.startFlushLatencyMeasurement();
        }
        BulkIndexAction action = new BulkIndexAction(this.indexRouter.indexFor(record), this.indexRouter.idFor(record), this.indexRouter.routingFor(record));
        return this.bulkIndexRequest.index(action, record, recordSequence);
    }

    public void flush() {
        if (this.bulkIndexRequest.isEmpty()) {
            return;
        }
        this.metrics.recordBulkSize(this.bulkIndexRequest.size());
        this.metrics.recordBulkMemorySize(this.bulkIndexRequest.memoryUsageBytes());
        this.metrics.measureFlushDuration(() -> {
            try {
                this.exportBulk();
                this.metrics.stopFlushLatencyMeasurement(this.flushLatencyMeasurement);
                this.bulkIndexRequest.clear();
            }
            catch (ElasticsearchExporterException e) {
                this.metrics.recordFailedFlush();
                throw e;
            }
        });
    }

    public boolean shouldFlush() {
        return this.bulkIndexRequest.memoryUsageBytes() >= this.configuration.bulk.memoryLimit || this.bulkIndexRequest.size() >= this.configuration.bulk.size;
    }

    public boolean putIndexTemplate(ValueType valueType) {
        return this.putIndexTemplate(valueType, VersionUtil.getVersionLowerCase());
    }

    public boolean putIndexTemplate(ValueType valueType, String version) {
        String templateName = this.indexRouter.indexPrefixForValueType(valueType, version);
        Template template = this.templateReader.readIndexTemplate(valueType, this.indexRouter.searchPatternForValueType(valueType, version), this.indexRouter.aliasNameForValueType(valueType));
        return this.putIndexTemplate(templateName, template);
    }

    public boolean putComponentTemplate() {
        Template template = this.templateReader.readComponentTemplate();
        return this.putComponentTemplate(template);
    }

    private void exportBulk() {
        BulkIndexResponse response;
        try {
            Request request = new Request("POST", "/_bulk");
            EntityTemplate body = new EntityTemplate((ContentProducer)this.bulkIndexRequest);
            body.setContentType("application/x-ndjson");
            request.setEntity((HttpEntity)body);
            response = this.sendRequest(request, BulkIndexResponse.class);
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException("Failed to flush bulk", e);
        }
        if (response.errors()) {
            this.throwCollectedBulkError(response);
        }
    }

    private void throwCollectedBulkError(BulkIndexResponse bulkResponse) {
        ArrayList collectedErrors = new ArrayList();
        bulkResponse.items().stream().flatMap(item -> Optional.ofNullable(item.index()).stream()).flatMap(index -> Optional.ofNullable(index.error()).stream()).collect(Collectors.groupingBy(BulkIndexResponse.Error::type)).forEach((errorType, errors) -> collectedErrors.add(String.format("Failed to flush %d item(s) of bulk request [type: %s, reason: %s]", errors.size(), errorType, ((BulkIndexResponse.Error)errors.get(0)).reason())));
        throw new ElasticsearchExporterException("Failed to flush bulk request: " + String.valueOf(collectedErrors));
    }

    private boolean putIndexTemplate(String templateName, Template template) {
        try {
            Request request = new Request("PUT", "/_index_template/" + templateName);
            request.setJsonEntity(MAPPER.writeValueAsString((Object)template));
            PutIndexTemplateResponse response = this.sendRequest(request, PutIndexTemplateResponse.class);
            return response.acknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException("Failed to put index template", e);
        }
    }

    private boolean putComponentTemplate(Template template) {
        try {
            Request request = new Request("PUT", "/_component_template/" + this.configuration.index.prefix);
            request.setJsonEntity(MAPPER.writeValueAsString((Object)template));
            PutIndexTemplateResponse response = this.sendRequest(request, PutIndexTemplateResponse.class);
            return response.acknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException("Failed to put component template", e);
        }
    }

    public boolean putIndexLifecycleManagementPolicy() {
        try {
            Request request = new Request("PUT", "/_ilm/policy/" + this.configuration.retention.getPolicyName());
            PutIndexLifecycleManagementPolicyRequest requestEntity = ElasticsearchClient.buildPutIndexLifecycleManagementPolicyRequest(this.configuration.retention.getMinimumAge());
            request.setJsonEntity(MAPPER.writeValueAsString((Object)requestEntity));
            PutIndexLifecycleManagementPolicyResponse response = this.sendRequest(request, PutIndexLifecycleManagementPolicyResponse.class);
            return response.acknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException("Failed to put index lifecycle management policy", e);
        }
    }

    public boolean bulkPutIndexLifecycleSettings(String policyName) {
        try {
            Request request = new Request("PUT", "/" + this.configuration.index.prefix + "*/_settings?allow_no_indices=true");
            PutIndexSettingsRequest requestEntity = new PutIndexSettingsRequest(new PutIndexSettingsRequest.Index(new PutIndexSettingsRequest.Lifecycle(policyName)));
            request.setJsonEntity(MAPPER.writeValueAsString((Object)requestEntity));
            PutIndexSettingsResponse response = this.sendRequest(request, PutIndexSettingsResponse.class);
            return response.acknowledged();
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException("Failed to update indices lifecycle settings", e);
        }
    }

    static PutIndexLifecycleManagementPolicyRequest buildPutIndexLifecycleManagementPolicyRequest(String minimumAge) {
        return new PutIndexLifecycleManagementPolicyRequest(new PutIndexLifecycleManagementPolicyRequest.Policy(new PutIndexLifecycleManagementPolicyRequest.Phases(new PutIndexLifecycleManagementPolicyRequest.Delete(minimumAge, new PutIndexLifecycleManagementPolicyRequest.Actions(new PutIndexLifecycleManagementPolicyRequest.DeleteAction())))));
    }

    private <T> T sendRequest(Request request, Class<T> responseType) throws IOException {
        Response response = this.client.performRequest(request);
        byte[] responseBody = response.getEntity().getContent().readAllBytes();
        return (T)MAPPER.readValue(responseBody, responseType);
    }
}

