/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import io.camunda.zeebe.exporter.ElasticsearchClient;
import io.camunda.zeebe.exporter.ElasticsearchExporterConfiguration;
import io.camunda.zeebe.protocol.record.ValueType;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)SchemaManager.class.getPackageName());
    private final ElasticsearchClient client;
    private final ElasticsearchExporterConfiguration configuration;
    private final Set<String> indexTemplatesCreated = new HashSet<String>();

    public SchemaManager(ElasticsearchClient client, ElasticsearchExporterConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
    }

    public SchemaManager(ElasticsearchExporterConfiguration configuration) {
        this.configuration = configuration;
        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        this.client = new ElasticsearchClient(configuration, (MeterRegistry)registry);
    }

    public void createSchema(String version) {
        if (!this.indexTemplatesCreated.contains(version)) {
            this.createIndexTemplates(version);
            this.updateRetentionPolicyForExistingIndices();
        }
    }

    private void updateRetentionPolicyForExistingIndices() {
        boolean acknowledged = this.configuration.retention.isEnabled() ? this.client.bulkPutIndexLifecycleSettings(this.configuration.retention.getPolicyName()) : this.client.bulkPutIndexLifecycleSettings(null);
        if (!acknowledged) {
            LOG.warn("Failed to acknowledge the the update of retention policy for existing indices");
        }
    }

    private void createIndexTemplates(String version) {
        if (this.configuration.retention.isEnabled() && this.configuration.retention.isManagePolicy()) {
            this.createIndexLifecycleManagementPolicy();
        }
        ElasticsearchExporterConfiguration.IndexConfiguration index = this.configuration.index;
        if (index.createTemplate) {
            this.createComponentTemplate();
            if (index.deployment) {
                this.createValueIndexTemplate(ValueType.DEPLOYMENT, version);
            }
            if (index.process) {
                this.createValueIndexTemplate(ValueType.PROCESS, version);
            }
            if (index.error) {
                this.createValueIndexTemplate(ValueType.ERROR, version);
            }
            if (index.incident) {
                this.createValueIndexTemplate(ValueType.INCIDENT, version);
            }
            if (index.job) {
                this.createValueIndexTemplate(ValueType.JOB, version);
            }
            if (index.jobBatch) {
                this.createValueIndexTemplate(ValueType.JOB_BATCH, version);
            }
            if (index.message) {
                this.createValueIndexTemplate(ValueType.MESSAGE, version);
            }
            if (index.messageBatch) {
                this.createValueIndexTemplate(ValueType.MESSAGE_BATCH, version);
            }
            if (index.messageSubscription) {
                this.createValueIndexTemplate(ValueType.MESSAGE_SUBSCRIPTION, version);
            }
            if (index.variable) {
                this.createValueIndexTemplate(ValueType.VARIABLE, version);
            }
            if (index.variableDocument) {
                this.createValueIndexTemplate(ValueType.VARIABLE_DOCUMENT, version);
            }
            if (index.processInstance) {
                this.createValueIndexTemplate(ValueType.PROCESS_INSTANCE, version);
            }
            if (index.processInstanceBatch) {
                this.createValueIndexTemplate(ValueType.PROCESS_INSTANCE_BATCH, version);
            }
            if (index.processInstanceCreation) {
                this.createValueIndexTemplate(ValueType.PROCESS_INSTANCE_CREATION, version);
            }
            if (index.processInstanceModification) {
                this.createValueIndexTemplate(ValueType.PROCESS_INSTANCE_MODIFICATION, version);
            }
            if (index.processMessageSubscription) {
                this.createValueIndexTemplate(ValueType.PROCESS_MESSAGE_SUBSCRIPTION, version);
            }
            if (index.decisionRequirements) {
                this.createValueIndexTemplate(ValueType.DECISION_REQUIREMENTS, version);
            }
            if (index.decision) {
                this.createValueIndexTemplate(ValueType.DECISION, version);
            }
            if (index.decisionEvaluation) {
                this.createValueIndexTemplate(ValueType.DECISION_EVALUATION, version);
            }
            if (index.checkpoint) {
                this.createValueIndexTemplate(ValueType.CHECKPOINT, version);
            }
            if (index.timer) {
                this.createValueIndexTemplate(ValueType.TIMER, version);
            }
            if (index.messageStartEventSubscription) {
                this.createValueIndexTemplate(ValueType.MESSAGE_START_EVENT_SUBSCRIPTION, version);
            }
            if (index.processEvent) {
                this.createValueIndexTemplate(ValueType.PROCESS_EVENT, version);
            }
            if (index.deploymentDistribution) {
                this.createValueIndexTemplate(ValueType.DEPLOYMENT_DISTRIBUTION, version);
            }
            if (index.escalation) {
                this.createValueIndexTemplate(ValueType.ESCALATION, version);
            }
            if (index.signal) {
                this.createValueIndexTemplate(ValueType.SIGNAL, version);
            }
            if (index.signalSubscription) {
                this.createValueIndexTemplate(ValueType.SIGNAL_SUBSCRIPTION, version);
            }
            if (index.resourceDeletion) {
                this.createValueIndexTemplate(ValueType.RESOURCE_DELETION, version);
            }
            if (index.commandDistribution) {
                this.createValueIndexTemplate(ValueType.COMMAND_DISTRIBUTION, version);
            }
            if (index.form) {
                this.createValueIndexTemplate(ValueType.FORM, version);
            }
            if (index.userTask) {
                this.createValueIndexTemplate(ValueType.USER_TASK, version);
            }
            if (index.processInstanceMigration) {
                this.createValueIndexTemplate(ValueType.PROCESS_INSTANCE_MIGRATION, version);
            }
            if (index.compensationSubscription) {
                this.createValueIndexTemplate(ValueType.COMPENSATION_SUBSCRIPTION, version);
            }
            if (index.messageCorrelation) {
                this.createValueIndexTemplate(ValueType.MESSAGE_CORRELATION, version);
            }
            if (index.user) {
                this.createValueIndexTemplate(ValueType.USER, version);
            }
            if (index.authorization) {
                this.createValueIndexTemplate(ValueType.AUTHORIZATION, version);
            }
        }
        this.indexTemplatesCreated.add(version);
    }

    private void createIndexLifecycleManagementPolicy() {
        if (!this.client.putIndexLifecycleManagementPolicy()) {
            LOG.warn("Failed to acknowledge the creation or update of the Index Lifecycle Management Policy");
        }
    }

    private void createComponentTemplate() {
        if (!this.client.putComponentTemplate()) {
            LOG.warn("Failed to acknowledge the creation or update of the component template");
        }
    }

    private void createValueIndexTemplate(ValueType valueType, String version) {
        if (!this.client.putIndexTemplate(valueType, version)) {
            LOG.warn("Failed to acknowledge the creation or update of the index template for value type {}", (Object)valueType);
        }
    }
}

