/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import io.camunda.zeebe.exporter.ElasticsearchExporterConfiguration;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

final class RestClientFactory {
    private static final RestClientFactory INSTANCE = new RestClientFactory();

    private RestClientFactory() {
    }

    static RestClient of(ElasticsearchExporterConfiguration config, HttpRequestInterceptor ... interceptors) {
        return INSTANCE.createRestClient(config, interceptors);
    }

    private RestClient createRestClient(ElasticsearchExporterConfiguration config, HttpRequestInterceptor ... interceptors) {
        HttpHost[] httpHosts = this.parseUrl(config);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts).setRequestConfigCallback(b -> b.setConnectTimeout(config.requestTimeoutMs).setSocketTimeout(config.requestTimeoutMs)).setHttpClientConfigCallback(b -> this.configureHttpClient(config, b, interceptors));
        return builder.build();
    }

    private HttpAsyncClientBuilder configureHttpClient(ElasticsearchExporterConfiguration config, HttpAsyncClientBuilder builder, HttpRequestInterceptor ... interceptors) {
        builder.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
        if (config.hasAuthenticationPresent()) {
            this.setupBasicAuthentication(config, builder);
        }
        for (HttpRequestInterceptor interceptor : interceptors) {
            builder.addInterceptorLast(interceptor);
        }
        return builder;
    }

    private void setupBasicAuthentication(ElasticsearchExporterConfiguration config, HttpAsyncClientBuilder builder) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.getAuthentication().getUsername(), config.getAuthentication().getPassword()));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
    }

    private HttpHost[] parseUrl(ElasticsearchExporterConfiguration config) {
        String[] urls = config.url.split(",");
        HttpHost[] hosts = new HttpHost[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            hosts[i] = HttpHost.create((String)urls[i]);
        }
        return hosts;
    }
}

