/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonAppend;
import io.camunda.zeebe.exporter.ElasticsearchExporterException;
import io.camunda.zeebe.exporter.RecordSequence;
import io.camunda.zeebe.exporter.dto.BulkIndexAction;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import io.camunda.zeebe.protocol.record.value.DeploymentRecordValue;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.JobRecordValue;
import io.camunda.zeebe.protocol.record.value.UserTaskRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.util.SemanticVersion;
import io.camunda.zeebe.util.VersionUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.entity.ContentProducer;

final class BulkIndexRequest
implements ContentProducer {
    private static final ObjectMapper MAPPER = new ObjectMapper().addMixIn(Record.class, RecordSequenceMixin.class).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    private static final ObjectMapper PREVIOUS_VERSION_MAPPER = new ObjectMapper().addMixIn(Record.class, Record85Mixin.class).addMixIn(CommandDistributionRecordValue.class, CommandDistribution85Mixin.class).addMixIn(DecisionRecordValue.class, Decision85Mixin.class).addMixIn(DeploymentRecordValue.class, Deployment85Mixin.class).addMixIn(FormMetadataValue.class, FormMetadata85Mixin.class).addMixIn(ProcessMetadataValue.class, ProcessMeta85Mixin.class).addMixIn(UserTaskRecordValue.class, UserTask85Mixin.class).addMixIn(IncidentRecordValue.class, Incident85Mixin.class).addMixIn(JobRecordValue.class, Job85Mixin.class).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_SINGLE_QUOTES});
    private static final String RECORD_SEQUENCE_PROPERTY = "sequence";
    private static final String RECORD_OPERATION_REFERENCE_PROPERTY = "operationReference";
    private static final String QUEUE_ID_PROPERTY = "queueId";
    private static final String DEPLOYMENT_KEY_PROPERTY = "deploymentKey";
    private static final String VERSION_TAG_PROPERTY = "versionTag";
    private static final String PRIORITY_PROPERTY = "priority";
    private static final String ELEMENT_INSTANCE_PATH_PROPERTY = "elementInstancePath";
    private static final String PROCESS_DEFINITION_PATH_PROPERTY = "processDefinitionPath";
    private static final String CALLING_ELEMENT_PATH_PROPERTY = "callingElementPath";
    private static final String JOB_LISTENER_EVENT_TYPE_PROPERTY = "jobListenerEventType";
    private static final String CHANGED_ATTRIBUTES_PROPERTY = "changedAttributes";
    private final List<BulkOperation> operations = new ArrayList<BulkOperation>();
    private BulkIndexAction lastIndexedMetadata;
    private int memoryUsageBytes = 0;

    BulkIndexRequest() {
    }

    boolean index(BulkIndexAction action, Record<?> record, RecordSequence recordSequence) {
        byte[] source;
        if (this.lastIndexedMetadata != null && this.lastIndexedMetadata.equals(action)) {
            return false;
        }
        try {
            source = BulkIndexRequest.serializeRecord(record, recordSequence);
        }
        catch (IOException e) {
            throw new ElasticsearchExporterException(String.format("Failed to serialize record to JSON for indexing action %s", action), e);
        }
        BulkOperation command = new BulkOperation(action, source);
        this.memoryUsageBytes += command.source().length;
        this.lastIndexedMetadata = action;
        this.operations.add(command);
        return true;
    }

    private static byte[] serializeRecord(Record<?> record, RecordSequence recordSequence) throws IOException {
        ObjectMapper mapper = BulkIndexRequest.isPreviousVersionRecord(record.getBrokerVersion()) ? PREVIOUS_VERSION_MAPPER : MAPPER;
        return mapper.writer().withAttribute((Object)RECORD_SEQUENCE_PROPERTY, (Object)recordSequence.sequence()).writeValueAsBytes(record);
    }

    int size() {
        return this.operations.size();
    }

    int memoryUsageBytes() {
        return this.memoryUsageBytes;
    }

    boolean isEmpty() {
        return this.operations.isEmpty();
    }

    void clear() {
        this.operations.clear();
        this.memoryUsageBytes = 0;
        this.lastIndexedMetadata = null;
    }

    BulkIndexAction lastIndexedMetadata() {
        return this.lastIndexedMetadata;
    }

    List<BulkOperation> bulkOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public void writeTo(OutputStream outStream) throws IOException {
        for (BulkOperation operation : this.operations) {
            MAPPER.writeValue(outStream, (Object)operation.metadata());
            outStream.write(10);
            outStream.write(operation.source());
            outStream.write(10);
        }
    }

    private static boolean isPreviousVersionRecord(String brokerVersion) {
        SemanticVersion semanticVersion = (SemanticVersion)SemanticVersion.parse((String)brokerVersion).orElseThrow(() -> new IllegalArgumentException("Expected to parse valid semantic version, but got [%s]".formatted(brokerVersion)));
        int currentMinorVersion = VersionUtil.getSemanticVersion().map(SemanticVersion::minor).orElseThrow(() -> new IllegalStateException("Expected to have a valid semantic version"));
        return semanticVersion.minor() < currentMinorVersion;
    }

    record BulkOperation(BulkIndexAction metadata, byte[] source) {
    }

    @JsonAppend(attrs={@JsonAppend.Attr(value="sequence")})
    private static final class RecordSequenceMixin {
        private RecordSequenceMixin() {
        }
    }

    @JsonAppend(attrs={@JsonAppend.Attr(value="sequence")})
    @JsonIgnoreProperties(value={"operationReference"})
    private static final class Record85Mixin {
        private Record85Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"queueId"})
    private static final class CommandDistribution85Mixin {
        private CommandDistribution85Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"deploymentKey", "versionTag"})
    private static final class Decision85Mixin {
        private Decision85Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"deploymentKey"})
    private static final class Deployment85Mixin {
        private Deployment85Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"deploymentKey", "versionTag"})
    private static final class FormMetadata85Mixin {
        private FormMetadata85Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"deploymentKey", "versionTag"})
    private static final class ProcessMeta85Mixin {
        private ProcessMeta85Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"priority"})
    private static final class UserTask85Mixin {
        private UserTask85Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"elementInstancePath", "processDefinitionPath", "callingElementPath"})
    private static final class Incident85Mixin {
        private Incident85Mixin() {
        }
    }

    @JsonIgnoreProperties(value={"jobListenerEventType", "changedAttributes"})
    private static final class Job85Mixin {
        private Job85Mixin() {
        }
    }
}

