/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.exporter;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;

public class ElasticsearchMetrics {
    private static final String NAMESPACE = "zeebe.elasticsearch.exporter";
    private final MeterRegistry meterRegistry;
    private final AtomicInteger bulkMemorySize = new AtomicInteger(0);
    private final Timer flushDuration;
    private final DistributionSummary bulkSize;
    private final Counter failedFlush;

    public ElasticsearchMetrics(MeterRegistry registry) {
        this.meterRegistry = registry;
        Gauge.builder((String)this.meterName("bulk.memory.size"), (Object)this.bulkMemorySize, AtomicInteger::get).description("Exporter bulk memory size").register(this.meterRegistry);
        this.flushDuration = Timer.builder((String)this.meterName("flush.duration.seconds")).description("Flush duration of bulk exporters in seconds").publishPercentileHistogram().minimumExpectedValue(Duration.ofMillis(10L)).register(this.meterRegistry);
        this.bulkSize = DistributionSummary.builder((String)this.meterName("bulk.size")).description("Exporter bulk size").serviceLevelObjectives(new double[]{10.0, 100.0, 1000.0, 10000.0, 100000.0}).register(this.meterRegistry);
        this.failedFlush = Counter.builder((String)this.meterName("failed.flush")).description("Number of failed flush operations").register(this.meterRegistry);
    }

    public void measureFlushDuration(Runnable flushFunction) {
        this.flushDuration.record(flushFunction);
    }

    public void recordBulkSize(int bulkSize) {
        this.bulkSize.record((double)bulkSize);
    }

    public void recordBulkMemorySize(int bulkMemorySize) {
        this.bulkMemorySize.set(bulkMemorySize);
    }

    public void recordFailedFlush() {
        this.failedFlush.increment();
    }

    private String meterName(String name) {
        return "zeebe.elasticsearch.exporter." + name;
    }
}

