/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe;

import com.google.common.util.concurrent.UncheckedExecutionException;
import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.CredentialsProvider;
import io.camunda.client.api.command.ClientStatusException;
import io.camunda.client.api.response.Topology;
import io.camunda.client.impl.NoopCredentialsProvider;
import io.camunda.zeebe.config.AppCfg;
import io.camunda.zeebe.config.AppConfigLoader;
import io.camunda.zeebe.config.AuthCfg;
import io.camunda.zeebe.util.FileUtil;
import io.camunda.zeebe.util.logging.ThrottledLogger;
import io.grpc.ClientInterceptor;
import io.grpc.Status;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.grpc.MetricCollectingClientInterceptor;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import io.micrometer.prometheusmetrics.PrometheusRenameFilter;
import io.prometheus.metrics.exporter.httpserver.HTTPServer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class App
implements Runnable {
    private static final Logger THROTTLED_LOGGER = new ThrottledLogger(LoggerFactory.getLogger(App.class), Duration.ofSeconds(5L));
    private static final Logger LOG = LoggerFactory.getLogger(App.class);
    protected final AppCfg config;
    protected PrometheusMeterRegistry registry;
    protected ClientInterceptor monitoringInterceptor;
    private HTTPServer monitoringServer;
    private final Path credentialsCachePath;

    protected App(AppCfg config) {
        this.config = config;
        Path credentialsCachePath = null;
        try {
            credentialsCachePath = Files.createTempDirectory(".camunda", new FileAttribute[0]).resolve("credentials.json");
        }
        catch (IOException e) {
            LOG.warn("Failed to create credentials cache directory; there will be no credentials cache, and you may run into rate limiting issues with your IdP", (Throwable)e);
        }
        this.credentialsCachePath = credentialsCachePath;
    }

    static void createApp(Function<AppCfg, App> appFactory) {
        AppCfg appCfg = AppConfigLoader.load();
        App app = appFactory.apply(appCfg);
        Runtime.getRuntime().addShutdownHook(new Thread(app::onShutdown));
        app.startMonitoringServer();
        app.run();
    }

    private void startMonitoringServer() {
        this.registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        this.registry.config().meterFilter((MeterFilter)new PrometheusRenameFilter());
        try {
            this.monitoringServer = HTTPServer.builder().port(this.config.getMonitoringPort()).registry(this.registry.getPrometheusRegistry()).buildAndStart();
        }
        catch (IOException e) {
            LOG.error("Problem on starting monitoring server.", (Throwable)e);
        }
        this.monitoringInterceptor = new MetricCollectingClientInterceptor((MeterRegistry)this.registry);
        this.registerDefaultInstrumentation();
    }

    private void registerDefaultInstrumentation() {
        new ClassLoaderMetrics().bindTo((MeterRegistry)this.registry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)this.registry);
        new JvmGcMetrics().bindTo((MeterRegistry)this.registry);
        new ProcessorMetrics().bindTo((MeterRegistry)this.registry);
        new JvmThreadMetrics().bindTo((MeterRegistry)this.registry);
    }

    private void onShutdown() {
        if (this.monitoringServer != null) {
            this.monitoringServer.stop();
            this.monitoringServer = null;
        }
        if (this.credentialsCachePath != null) {
            try {
                FileUtil.deleteFolderIfExists((Path)this.credentialsCachePath.getParent());
            }
            catch (IOException e) {
                LOG.debug("Failed to delete credentials cache directory", (Throwable)e);
            }
        }
    }

    void printTopology(CamundaClient client) {
        while (true) {
            try {
                Topology topology = (Topology)client.newTopologyRequest().send().join();
                topology.getBrokers().forEach(b -> {
                    LOG.info("Broker {} - {}", (Object)b.getNodeId(), (Object)b.getAddress());
                    b.getPartitions().forEach(p -> LOG.info("{} - {}", (Object)p.getPartitionId(), (Object)p.getRole()));
                });
            }
            catch (ClientStatusException e) {
                Status.Code statusCode = e.getStatusCode();
                if (!statusCode.equals((Object)Status.Code.UNAUTHENTICATED) && !statusCode.equals((Object)Status.Code.PERMISSION_DENIED)) continue;
                LOG.error("Failed to retrieve topology due to authentication error; check your config", (Throwable)e);
                System.exit(1);
                continue;
            }
            catch (Exception e) {
                THROTTLED_LOGGER.warn("Topology request failed", (Throwable)e);
                continue;
            }
            break;
        }
    }

    protected CamundaClientBuilder newClientBuilder() {
        CamundaClientBuilder builder = CamundaClient.newClientBuilder().grpcAddress(URI.create(this.config.getBrokerUrl())).restAddress(URI.create(this.config.getBrokerRestUrl())).preferRestOverGrpc(this.config.isPreferRest()).withProperties(System.getProperties()).withInterceptors(new ClientInterceptor[]{this.monitoringInterceptor});
        AuthCfg auth = this.config.getAuth();
        NoopCredentialsProvider credentialsProvider = switch (auth.getType()) {
            case AuthCfg.AuthType.NONE -> new NoopCredentialsProvider();
            case AuthCfg.AuthType.BASIC -> CredentialsProvider.newBasicAuthCredentialsProviderBuilder().username(auth.getBasic().getUsername()).password(auth.getBasic().getPassword()).applyEnvironmentOverrides(true).build();
            case AuthCfg.AuthType.OAUTH -> {
                String cachePath = this.credentialsCachePath != null ? this.credentialsCachePath.toAbsolutePath().toString() : null;
                yield CredentialsProvider.newCredentialsProviderBuilder().clientId(auth.getOauth().getClientId()).clientSecret(auth.getOauth().getClientSecret()).audience(auth.getOauth().getAudience()).authorizationServerUrl(auth.getOauth().getAuthzUrl()).credentialsCachePath(cachePath).applyEnvironmentOverrides(true).build();
            }
            default -> throw new IllegalStateException("Expect app.auth.type to be one of %s, but was '%s'".formatted(new Object[]{AuthCfg.AuthType.values(), auth.getType()}));
        };
        return builder.credentialsProvider((CredentialsProvider)credentialsProvider);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String readVariables(String payloadPath) {
        try {
            ClassLoader classLoader = App.class.getClassLoader();
            try (InputStream fromResource = classLoader.getResourceAsStream(payloadPath);){
                String string;
                if (fromResource != null) {
                    String string2 = this.tryReadVariables(fromResource);
                    return string2;
                }
                try (FileInputStream fromFile = new FileInputStream(payloadPath);){
                    string = this.tryReadVariables(fromFile);
                }
                return string;
            }
        }
        catch (IOException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    private String tryReadVariables(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(inputStream);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        return stringBuilder.toString();
    }
}

