/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe;

import io.camunda.zeebe.Worker;
import io.camunda.zeebe.util.logging.ThrottledLogger;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseChecker
extends Thread {
    private static final Logger THROTTLED_LOGGER = new ThrottledLogger(LoggerFactory.getLogger(Worker.class), Duration.ofSeconds(5L));
    private final BlockingQueue<Future<?>> futures;
    private volatile boolean shuttingDown = false;

    public ResponseChecker(BlockingQueue<Future<?>> futures) {
        this.futures = futures;
    }

    @Override
    public void run() {
        while (!this.shuttingDown) {
            try {
                this.futures.take().get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                StatusRuntimeException statusRuntimeException;
                Throwable cause = e.getCause();
                if (!(cause instanceof StatusRuntimeException) || (statusRuntimeException = (StatusRuntimeException)cause).getStatus().getCode() == Status.Code.RESOURCE_EXHAUSTED) continue;
                THROTTLED_LOGGER.warn("Request failed", (Throwable)e);
            }
        }
    }

    public void close() {
        this.shuttingDown = true;
        this.interrupt();
    }
}

