/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.client.CamundaClient;
import io.camunda.client.CamundaClientBuilder;
import io.camunda.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.App;
import io.camunda.zeebe.ResponseChecker;
import io.camunda.zeebe.config.AppCfg;
import io.camunda.zeebe.config.StarterCfg;
import io.camunda.zeebe.util.logging.ThrottledLogger;
import io.grpc.ClientInterceptor;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Starter
extends App {
    private static final Logger THROTTLED_LOGGER = new ThrottledLogger(LoggerFactory.getLogger(Starter.class), Duration.ofSeconds(5L));
    private static final Logger LOG = LoggerFactory.getLogger(Starter.class);
    private static final long NANOS_PER_SECOND = Duration.ofSeconds(1L).toNanos();
    private static final TypeReference<HashMap<String, Object>> VARIABLES_TYPE_REF = new TypeReference<HashMap<String, Object>>(){};
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final AppCfg appCfg;

    Starter(AppCfg appCfg) {
        this.appCfg = appCfg;
    }

    @Override
    public void run() {
        StarterCfg starterCfg = this.appCfg.getStarter();
        int rate = starterCfg.getRate();
        String processId = starterCfg.getProcessId();
        ArrayBlockingQueue requestFutures = new ArrayBlockingQueue(5000);
        CamundaClient client = this.createCamundaClient();
        this.printTopology(client);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(starterCfg.getThreads());
        this.deployProcess(client, starterCfg);
        long intervalNanos = Math.floorDiv(NANOS_PER_SECOND, rate);
        LOG.info("Creating an instance every {}ns", (Object)intervalNanos);
        String variablesString = this.readVariables(starterCfg.getPayloadPath());
        HashMap<String, Object> variables = Starter.deserializeVariables(variablesString);
        BooleanSupplier shouldContinue = this.createContinuationCondition(starterCfg);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        AtomicLong businessKey = new AtomicLong(0L);
        ScheduledFuture<?> scheduledTask = executorService.scheduleAtFixedRate(() -> {
            variables.put(starterCfg.getBusinessKey(), businessKey.incrementAndGet());
            this.runStarter(starterCfg, processId, requestFutures, client, Starter.serializeVariables(variables), shouldContinue, countDownLatch);
        }, 0L, intervalNanos, TimeUnit.NANOSECONDS);
        ResponseChecker responseChecker = new ResponseChecker(requestFutures);
        responseChecker.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (!executorService.isShutdown()) {
                executorService.shutdown();
                try {
                    executorService.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.error("Shutdown executor service was interrupted", (Throwable)e);
                }
            }
            if (responseChecker.isAlive()) {
                responseChecker.close();
            }
        }));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Awaiting of count down latch was interrupted.", (Throwable)e);
        }
        LOG.info("Starter finished");
        scheduledTask.cancel(true);
        executorService.shutdown();
        responseChecker.close();
    }

    private static HashMap<String, Object> deserializeVariables(String variablesString) {
        HashMap variables;
        try {
            variables = (HashMap)OBJECT_MAPPER.readValue(variablesString, VARIABLES_TYPE_REF);
        }
        catch (JsonProcessingException e) {
            LOG.error(String.format("Failed to parse variables '%s'.", variablesString), (Throwable)e);
            throw new RuntimeException(e);
        }
        return variables;
    }

    private static String serializeVariables(HashMap<String, Object> variables) {
        try {
            return OBJECT_MAPPER.writeValueAsString(variables);
        }
        catch (JsonProcessingException e) {
            LOG.error(String.format("Failed to convert variables to string: '%s' ", variables), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void runStarter(StarterCfg starterCfg, String processId, BlockingQueue<Future<?>> requestFutures, CamundaClient client, String variables, BooleanSupplier shouldContinue, CountDownLatch countDownLatch) {
        block5: {
            if (shouldContinue.getAsBoolean()) {
                try {
                    if (starterCfg.isStartViaMessage()) {
                        requestFutures.put((Future<?>)client.newPublishMessageCommand().messageName(starterCfg.getMsgName()).correlationKey(UUID.randomUUID().toString()).variables(variables).timeToLive(Duration.ZERO).send());
                        break block5;
                    }
                    Starter.startViaCommand(starterCfg, processId, requestFutures, client, variables);
                }
                catch (Exception e) {
                    THROTTLED_LOGGER.error("Error on creating new process instance", (Throwable)e);
                }
            } else {
                countDownLatch.countDown();
            }
        }
    }

    private static void startViaCommand(StarterCfg starterCfg, String processId, BlockingQueue<Future<?>> requestFutures, CamundaClient client, String variables) throws InterruptedException {
        if (starterCfg.isWithResults()) {
            requestFutures.put((Future<?>)client.newCreateInstanceCommand().bpmnProcessId(processId).latestVersion().variables(variables).withResult().requestTimeout(starterCfg.getWithResultsTimeout()).send());
        } else {
            requestFutures.put((Future<?>)client.newCreateInstanceCommand().bpmnProcessId(processId).latestVersion().variables(variables).send());
        }
    }

    private CamundaClient createCamundaClient() {
        CamundaClientBuilder builder = CamundaClient.newClientBuilder().grpcAddress(URI.create(this.appCfg.getBrokerUrl())).restAddress(URI.create(this.appCfg.getBrokerRestUrl())).preferRestOverGrpc(this.appCfg.isPreferRest()).numJobWorkerExecutionThreads(0).withProperties(System.getProperties()).withInterceptors(new ClientInterceptor[]{monitoringInterceptor});
        if (!this.appCfg.isTls()) {
            builder.usePlaintext();
        }
        return builder.build();
    }

    private void deployProcess(CamundaClient client, StarterCfg starterCfg) {
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployCmd = Starter.constructDeploymentCommand(client, starterCfg);
        while (true) {
            try {
                deployCmd.send().join();
            }
            catch (Exception e) {
                THROTTLED_LOGGER.warn("Failed to deploy process, retrying", (Throwable)e);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
    }

    private static DeployResourceCommandStep1.DeployResourceCommandStep2 constructDeploymentCommand(CamundaClient client, StarterCfg starterCfg) {
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployCmd = client.newDeployResourceCommand().addResourceFromClasspath(starterCfg.getBpmnXmlPath());
        List<String> extraBpmnModels = starterCfg.getExtraBpmnModels();
        if (extraBpmnModels != null) {
            for (String model : extraBpmnModels) {
                deployCmd.addResourceFromClasspath(model);
            }
        }
        return deployCmd;
    }

    private BooleanSupplier createContinuationCondition(StarterCfg starterCfg) {
        int durationLimit = starterCfg.getDurationLimit();
        if (durationLimit > 0) {
            LocalDateTime endTime = LocalDateTime.now().plus(durationLimit, ChronoUnit.SECONDS);
            return () -> LocalDateTime.now().isBefore(endTime);
        }
        return () -> true;
    }

    public static void main(String[] args) {
        Starter.createApp(Starter::new);
    }
}

