/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe;

import com.google.common.util.concurrent.UncheckedExecutionException;
import io.camunda.client.CamundaClient;
import io.camunda.client.api.response.Topology;
import io.camunda.zeebe.config.AppCfg;
import io.camunda.zeebe.config.AppConfigLoader;
import io.camunda.zeebe.util.logging.ThrottledLogger;
import io.grpc.ClientInterceptor;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.grpc.MetricCollectingClientInterceptor;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.prometheusmetrics.PrometheusConfig;
import io.micrometer.prometheusmetrics.PrometheusMeterRegistry;
import io.micrometer.prometheusmetrics.PrometheusRenameFilter;
import io.prometheus.metrics.exporter.httpserver.HTTPServer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.time.Duration;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class App
implements Runnable {
    protected static ClientInterceptor monitoringInterceptor;
    protected static PrometheusMeterRegistry registry;
    private static final Logger THROTTLED_LOGGER;
    private static final Logger LOG;
    private static HTTPServer monitoringServer;

    App() {
    }

    static void createApp(Function<AppCfg, Runnable> appFactory) {
        AppCfg appCfg = AppConfigLoader.load();
        App.startMonitoringServer(appCfg);
        Runtime.getRuntime().addShutdownHook(new Thread(App::stopMonitoringServer));
        appFactory.apply(appCfg).run();
    }

    private static void startMonitoringServer(AppCfg appCfg) {
        registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        registry.config().meterFilter((MeterFilter)new PrometheusRenameFilter());
        try {
            monitoringServer = HTTPServer.builder().port(appCfg.getMonitoringPort()).registry(registry.getPrometheusRegistry()).buildAndStart();
        }
        catch (IOException e) {
            LOG.error("Problem on starting monitoring server.", (Throwable)e);
        }
        monitoringInterceptor = new MetricCollectingClientInterceptor((MeterRegistry)registry);
        App.registerDefaultInstrumentation();
    }

    private static void registerDefaultInstrumentation() {
        new ClassLoaderMetrics().bindTo((MeterRegistry)registry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)registry);
        new JvmGcMetrics().bindTo((MeterRegistry)registry);
        new ProcessorMetrics().bindTo((MeterRegistry)registry);
        new JvmThreadMetrics().bindTo((MeterRegistry)registry);
    }

    private static void stopMonitoringServer() {
        if (monitoringServer != null) {
            monitoringServer.stop();
            monitoringServer = null;
        }
    }

    void printTopology(CamundaClient client) {
        while (true) {
            try {
                Topology topology = (Topology)client.newTopologyRequest().send().join();
                topology.getBrokers().forEach(b -> {
                    LOG.info("Broker {} - {}", (Object)b.getNodeId(), (Object)b.getAddress());
                    b.getPartitions().forEach(p -> LOG.info("{} - {}", (Object)p.getPartitionId(), (Object)p.getRole()));
                });
            }
            catch (Exception e) {
                THROTTLED_LOGGER.warn("Topology request failed", (Throwable)e);
                continue;
            }
            break;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected String readVariables(String payloadPath) {
        try {
            ClassLoader classLoader = App.class.getClassLoader();
            try (InputStream fromResource = classLoader.getResourceAsStream(payloadPath);){
                String string;
                if (fromResource != null) {
                    String string2 = this.tryReadVariables(fromResource);
                    return string2;
                }
                try (FileInputStream fromFile = new FileInputStream(payloadPath);){
                    string = this.tryReadVariables(fromFile);
                }
                return string;
            }
        }
        catch (IOException e) {
            throw new UncheckedExecutionException((Throwable)e);
        }
    }

    private String tryReadVariables(InputStream inputStream) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(inputStream);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    static {
        THROTTLED_LOGGER = new ThrottledLogger(LoggerFactory.getLogger(App.class), Duration.ofSeconds(5L));
        LOG = LoggerFactory.getLogger(App.class);
    }
}

